/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.domain;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.jclouds.azurecompute.arm.domain.AutoValue_Resource;
import org.jclouds.azurecompute.arm.domain.AutoValue_Resource_Identity;
import org.jclouds.azurecompute.arm.domain.AutoValue_Resource_ResourceProperties;
import org.jclouds.azurecompute.arm.domain.Plan;
import org.jclouds.azurecompute.arm.domain.SKU;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

public abstract class Resource {
    public abstract String id();

    public abstract String name();

    public abstract String type();

    public abstract String location();

    @Nullable
    public abstract Map<String, String> tags();

    @Nullable
    public abstract Identity identity();

    @Nullable
    public abstract SKU sku();

    @Nullable
    public abstract String managedBy();

    @Nullable
    public abstract String kind();

    @Nullable
    public abstract Plan plan();

    @Nullable
    public abstract ResourceProperties properties();

    @SerializedNames(value={"id", "name", "type", "location", "tags", "identity", "sku", "managedBy", "kind", "plan", "properties"})
    public static Resource create(String id, String name, String type, String location, Map<String, String> tags, Identity identity, SKU sku, String managedBy, String kind, Plan plan, ResourceProperties properties) {
        return new AutoValue_Resource(id, name, type, location, tags == null ? null : ImmutableMap.copyOf(tags), identity, sku, managedBy, kind, plan, properties);
    }

    public static abstract class ResourceProperties {
        @Nullable
        public abstract String provisioningState();

        @SerializedNames(value={"provisioningState"})
        public static ResourceProperties create(String provisioningState) {
            return new AutoValue_Resource_ResourceProperties(provisioningState);
        }
    }

    public static abstract class Identity {
        public abstract String principalId();

        public abstract String tenantId();

        public abstract String type();

        @SerializedNames(value={"principalId", "tenantId", "type"})
        public static Identity create(String principalId, String tenantId, String type) {
            return new AutoValue_Resource_Identity(principalId, tenantId, type);
        }
    }
}

