/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.handlers;

import java.io.IOException;
import javax.inject.Singleton;
import org.jclouds.azurecompute.arm.exceptions.AzureComputeRateLimitExceededException;
import org.jclouds.azurecompute.arm.handlers.AzureRateLimitRetryHandler;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.util.Closeables2;
import org.jclouds.util.Strings2;

@Singleton
public class AzureComputeErrorHandler
implements HttpErrorHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public void handleError(HttpCommand command, HttpResponse response) {
        message = this.parseMessage(response);
        exception /* !! */  = message == null ? new HttpResponseException(command, response) : new HttpResponseException(command, response, message);
        try {
            message = message == null ? String.format("%s -> %s", new Object[]{command.getCurrentRequest().getRequestLine(), response.getStatusLine()}) : message;
            switch (response.getStatusCode()) {
                case 400: {
                    if (message.contains("unauthorized_client")) {
                        exception /* !! */  = new AuthorizationException(message, exception /* !! */ );
                        ** break;
lbl10:
                        // 1 sources

                    } else {
                        exception /* !! */  = new IllegalArgumentException(message, exception /* !! */ );
                        ** break;
                    }
lbl13:
                    // 1 sources

                    break;
                }
                case 401: 
                case 403: {
                    exception /* !! */  = new AuthorizationException(message, exception /* !! */ );
                    ** break;
lbl17:
                    // 1 sources

                    break;
                }
                case 404: {
                    if (command.getCurrentRequest().getMethod().equals("DELETE")) ** break;
                    exception /* !! */  = new ResourceNotFoundException(message, exception /* !! */ );
                    ** break;
lbl22:
                    // 1 sources

                    break;
                }
                case 409: {
                    exception /* !! */  = new IllegalStateException(message, exception /* !! */ );
                    ** break;
lbl26:
                    // 1 sources

                    break;
                }
                case 429: {
                    if (AzureRateLimitRetryHandler.isRateLimitError(response)) {
                        exception /* !! */  = new AzureComputeRateLimitExceededException(response, (Throwable)exception /* !! */ );
                        ** break;
lbl31:
                        // 1 sources

                    } else {
                        exception /* !! */  = new IllegalStateException(message, exception /* !! */ );
                        ** break;
                    }
lbl34:
                    // 1 sources

                    break;
                }
                ** default:
lbl36:
                // 1 sources

                break;
            }
        }
        finally {
            Closeables2.closeQuietly(response.getPayload());
            command.setException(exception /* !! */ );
        }
    }

    public String parseMessage(HttpResponse response) {
        if (response.getPayload() == null) {
            return null;
        }
        try {
            return Strings2.toStringAndClose(response.getPayload().openStream());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

