/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.cloudstack.CloudStackApi;
import org.jclouds.cloudstack.domain.SecurityGroup;
import org.jclouds.cloudstack.domain.Zone;
import org.jclouds.cloudstack.domain.ZoneSecurityGroupNamePortsCidrs;
import org.jclouds.cloudstack.options.AccountInDomainOptions;
import org.jclouds.cloudstack.predicates.SecurityGroupPredicates;
import org.jclouds.cloudstack.predicates.ZonePredicates;
import org.jclouds.logging.Logger;

@Singleton
public class CreateSecurityGroupIfNeeded
implements Function<ZoneSecurityGroupNamePortsCidrs, SecurityGroup> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final CloudStackApi client;
    protected final Supplier<LoadingCache<String, Zone>> zoneIdToZone;
    protected final Predicate<String> jobComplete;

    @Inject
    public CreateSecurityGroupIfNeeded(CloudStackApi client, Predicate<String> jobComplete, Supplier<LoadingCache<String, Zone>> zoneIdToZone) {
        this.client = Preconditions.checkNotNull(client, "client");
        this.jobComplete = Preconditions.checkNotNull(jobComplete, "jobComplete");
        this.zoneIdToZone = zoneIdToZone;
    }

    @Override
    public SecurityGroup apply(ZoneSecurityGroupNamePortsCidrs input) {
        Preconditions.checkNotNull(input, "input");
        String zoneId = input.getZone();
        Zone zone = this.zoneIdToZone.get().getUnchecked(zoneId);
        Preconditions.checkArgument(ZonePredicates.supportsSecurityGroups().apply(zone), "Security groups are required, but the zone %s does not support security groups", (Object)zoneId);
        this.logger.debug(">> creating securityGroup %s", input);
        try {
            SecurityGroup securityGroup = this.client.getSecurityGroupApi().createSecurityGroup(input.getName());
            this.logger.debug("<< created securityGroup(%s)", securityGroup);
            ImmutableSet<String> cidrs = !input.getCidrs().isEmpty() ? ImmutableSet.copyOf(input.getCidrs()) : ImmutableSet.of("0.0.0.0/0");
            for (int port : input.getPorts()) {
                this.authorizeGroupToItselfAndToTCPPortAndCidr(this.client, securityGroup, port, cidrs);
            }
            return securityGroup;
        }
        catch (IllegalStateException e) {
            this.logger.trace("<< trying to find securityGroup(%s): %s", input, e.getMessage());
            SecurityGroup group = this.client.getSecurityGroupApi().getSecurityGroupByName(input.getName());
            this.logger.debug("<< reused securityGroup(%s)", group.getId());
            return group;
        }
    }

    private void authorizeGroupToItselfAndToTCPPortAndCidr(CloudStackApi client, SecurityGroup securityGroup, int port, Set<String> cidrs) {
        for (String cidr : cidrs) {
            this.logger.debug(">> authorizing securityGroup(%s) permission to %s on port %d", securityGroup, cidr, port);
            if (SecurityGroupPredicates.portInRangeForCidr(port, cidr).apply(securityGroup)) continue;
            this.jobComplete.apply(client.getSecurityGroupApi().authorizeIngressPortsToCIDRs(securityGroup.getId(), "TCP", port, port, ImmutableSet.of(cidr), new AccountInDomainOptions[0]));
            this.logger.debug("<< authorized securityGroup(%s) permission to %s on port %d", securityGroup, cidr, port);
        }
    }
}

