/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.TypeLiteral;
import java.util.Map;
import java.util.Set;
import javax.inject.Singleton;
import org.jclouds.cloudstack.domain.AsyncJob;
import org.jclouds.cloudstack.functions.ParseTypedAsyncJob;
import org.jclouds.domain.JsonBall;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseFirstJsonValueNamed;
import org.jclouds.json.internal.GsonWrapper;

@Singleton
public class ParseAsyncJobsFromHttpResponse
implements Function<HttpResponse, Set<AsyncJob<?>>> {
    private final ParseFirstJsonValueNamed<Set<AsyncJob<Map<String, JsonBall>>>> parser;
    private final ParseTypedAsyncJob parseTyped;

    @Inject
    public ParseAsyncJobsFromHttpResponse(ParseTypedAsyncJob parseTyped, GsonWrapper gsonView) {
        this.parseTyped = Preconditions.checkNotNull(parseTyped, "parseTyped");
        this.parser = new ParseFirstJsonValueNamed<Set<AsyncJob<Map<String, JsonBall>>>>(Preconditions.checkNotNull(gsonView, "gsonView"), new TypeLiteral<Set<AsyncJob<Map<String, JsonBall>>>>(){}, "asyncjobs");
    }

    @Override
    public Set<AsyncJob<?>> apply(HttpResponse response) {
        Preconditions.checkNotNull(response, "response");
        Set<AsyncJob<Map<String, JsonBall>>> toParse = this.parser.apply(response);
        Preconditions.checkNotNull(toParse, "parsed result from %s", (Object)response);
        return ImmutableSet.copyOf(Iterables.transform(toParse, this.parseTyped));
    }
}

