/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import org.jclouds.compute.domain.ComputeType;
import org.jclouds.compute.domain.internal.ComputeMetadataImpl;
import org.jclouds.domain.Location;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.net.domain.IpPermission;

public class SecurityGroup
extends ComputeMetadataImpl {
    private final Set<IpPermission> ipPermissions;
    private final String ownerId;

    public SecurityGroup(String providerId, String name, String id, @Nullable Location location, URI uri, Map<String, String> userMetadata, Set<String> tags, Iterable<IpPermission> ipPermissions, @Nullable String ownerId) {
        super(ComputeType.SECURITYGROUP, providerId, name, id, location, uri, userMetadata, tags);
        this.ipPermissions = ImmutableSet.copyOf(Preconditions.checkNotNull(ipPermissions, "ipPermissions"));
        this.ownerId = ownerId;
    }

    public Set<IpPermission> getIpPermissions() {
        return this.ipPermissions;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    @Override
    protected MoreObjects.ToStringHelper string() {
        MoreObjects.ToStringHelper helper = this.computeToStringPrefix();
        if (!this.ipPermissions.isEmpty()) {
            helper.add("ipPermissions", this.ipPermissions);
        }
        return this.addComputeToStringSuffix(helper);
    }
}

