/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.strategy;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.inject.assistedinject.Assisted;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.jclouds.compute.callables.RunScriptOnNode;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.options.RunScriptOptions;
import org.jclouds.scriptbuilder.domain.Statement;

public class InitializeRunScriptOnNodeOrPlaceInBadMap
implements Callable<RunScriptOnNode> {
    private final RunScriptOnNode.Factory runScriptOnNodeFactory;
    private final Statement script;
    private final Map<NodeMetadata, Exception> badNodes;
    private final NodeMetadata node;
    private final RunScriptOptions options;

    @Inject
    InitializeRunScriptOnNodeOrPlaceInBadMap(RunScriptOnNode.Factory runScriptOnNodeFactory, @Assisted NodeMetadata node, @Assisted Statement script, @Assisted RunScriptOptions options, @Assisted Map<NodeMetadata, Exception> badNodes) {
        this.runScriptOnNodeFactory = Preconditions.checkNotNull(runScriptOnNodeFactory, "runScriptOnNodeFactory");
        this.script = Preconditions.checkNotNull(script, "script");
        this.badNodes = Preconditions.checkNotNull(badNodes, "badNodes");
        this.node = Preconditions.checkNotNull(node, "node");
        this.options = Preconditions.checkNotNull(options, "options");
    }

    @Override
    public RunScriptOnNode call() throws Exception {
        try {
            return this.runScriptOnNodeFactory.create(this.node, this.script, this.options).init();
        }
        catch (Exception e) {
            this.badNodes.put(this.node, e);
            return null;
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("node", this.node).add("options", this.options).toString();
    }

    public static interface Factory {
        public Callable<RunScriptOnNode> create(NodeMetadata var1, Statement var2, RunScriptOptions var3, Map<NodeMetadata, Exception> var4);
    }
}

