/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean2.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.net.URI;
import org.jclouds.digitalocean2.domain.options.ListOptions;
import org.jclouds.http.utils.Queries;

public class LinkToListOptions
implements Function<URI, ListOptions> {
    @Override
    public ListOptions apply(URI input) {
        Preconditions.checkNotNull(input, "input cannot be null");
        Multimap<String, String> queryParams = Queries.queryParser().apply(input.getQuery());
        String nextPage = LinkToListOptions.getFirstOrNull("page", queryParams);
        String nextPerPage = LinkToListOptions.getFirstOrNull("per_page", queryParams);
        ListOptions options = new ListOptions();
        if (nextPage != null) {
            options.page(Integer.parseInt(nextPage));
        }
        if (nextPerPage != null) {
            options.perPage(Integer.parseInt(nextPerPage));
        }
        return options;
    }

    public static String getFirstOrNull(String key, Multimap<String, String> params) {
        return params.containsKey(key) ? Strings.emptyToNull(Iterables.getFirst(params.get(key), null)) : null;
    }
}

