/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.beans.ConstructorProperties;
import org.jclouds.gogrid.domain.Ip;

public class IpPortPair
implements Comparable<IpPortPair> {
    private final Ip ip;
    private final int port;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromIpPortPair(this);
    }

    @ConstructorProperties(value={"ip", "port"})
    protected IpPortPair(Ip ip, int port) {
        this.ip = Preconditions.checkNotNull(ip, "ip");
        this.port = port;
    }

    public Ip getIp() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public int hashCode() {
        return Objects.hashCode(this.ip, this.port);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IpPortPair that = (IpPortPair)IpPortPair.class.cast(obj);
        return Objects.equal(this.ip, that.ip) && Objects.equal(this.port, that.port);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper(this).add("ip", this.ip).add("port", this.port);
    }

    public String toString() {
        return this.string().toString();
    }

    @Override
    public int compareTo(IpPortPair o) {
        if (this.ip != null && o.getIp() != null) {
            return Longs.compare(this.ip.getId(), o.getIp().getId());
        }
        return Ints.compare(this.port, o.getPort());
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected Ip ip;
        protected int port;

        protected abstract T self();

        public T ip(Ip ip) {
            this.ip = ip;
            return this.self();
        }

        public T port(int port) {
            this.port = port;
            return this.self();
        }

        public IpPortPair build() {
            return new IpPortPair(this.ip, this.port);
        }

        public T fromIpPortPair(IpPortPair in) {
            return ((Builder)this.ip(in.getIp())).port(in.getPort());
        }
    }
}

