/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.auth.config;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import org.jclouds.openstack.keystone.auth.config.CredentialType;

public class CredentialTypes {
    public static final String API_ACCESS_KEY_CREDENTIALS = "apiAccessKeyCredentials";
    public static final String PASSWORD_CREDENTIALS = "passwordCredentials";
    public static final String TOKEN_CREDENTIALS = "tokenCredentials";

    public static <T> String credentialTypeOf(T input) {
        Class<?> authenticationType = input.getClass();
        CredentialType credentialType = CredentialTypes.findCredentialType(authenticationType);
        Preconditions.checkArgument(credentialType != null, "programming error: %s should have annotation %s", authenticationType, (Object)CredentialType.class.getName());
        return credentialType.value();
    }

    public static <T> Map<String, T> indexByCredentialType(Iterable<T> iterable) {
        return Maps.uniqueIndex(iterable, new Function<T, String>(){

            @Override
            public String apply(T input) {
                return CredentialTypes.credentialTypeOf(input);
            }
        });
    }

    public static CredentialType findCredentialType(Class<?> input) {
        if (input == null) {
            return null;
        }
        CredentialType ann = input.getAnnotation(CredentialType.class);
        return ann != null ? ann : CredentialTypes.findCredentialType(input.getSuperclass());
    }
}

