/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.binders;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.http.HttpRequest;
import org.jclouds.json.Json;
import org.jclouds.openstack.keystone.auth.config.CredentialType;
import org.jclouds.openstack.keystone.auth.config.CredentialTypes;
import org.jclouds.openstack.keystone.auth.domain.TenantOrDomainAndCredentials;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.binders.BindToJsonPayload;
import org.jclouds.rest.internal.GeneratedHttpRequest;

@Singleton
public class BindAuthToJsonPayload
extends BindToJsonPayload
implements MapBinder {
    @Inject
    public BindAuthToJsonPayload(Json jsonBinder) {
        super(jsonBinder);
    }

    protected TenantOrDomainAndCredentials<?> findCredentialsInArgs(GeneratedHttpRequest gRequest) {
        Optional<Object> credentials = Iterables.tryFind(gRequest.getInvocation().getArgs(), Predicates.instanceOf(TenantOrDomainAndCredentials.class));
        return credentials.isPresent() ? (TenantOrDomainAndCredentials)credentials.get() : null;
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        Preconditions.checkArgument(Preconditions.checkNotNull(request, "request") instanceof GeneratedHttpRequest, "this binder is only valid for GeneratedHttpRequests!");
        GeneratedHttpRequest gRequest = (GeneratedHttpRequest)request;
        ImmutableMap.Builder<String, Object> builder = ImmutableMap.builder();
        TenantOrDomainAndCredentials<?> credentials = this.findCredentialsInArgs(gRequest);
        if (credentials != null) {
            CredentialType credentialType = CredentialTypes.findCredentialType(credentials.credentials().getClass());
            Preconditions.checkArgument(credentialType != null, "the given credentials must be annotated with @CredentialType");
            builder.put(credentialType.value(), credentials.credentials());
            if (credentials != null) {
                if (!Strings.isNullOrEmpty(credentials.tenantOrDomainId())) {
                    builder.put("tenantId", credentials.tenantOrDomainId());
                } else if (!Strings.isNullOrEmpty(credentials.tenantOrDomainName())) {
                    builder.put("tenantName", credentials.tenantOrDomainName());
                }
            }
        }
        R authRequest = super.bindToRequest(request, ImmutableMap.of("auth", builder.build()));
        authRequest.getPayload().setSensitive(true);
        return authRequest;
    }
}

