/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.util.Map;
import javax.inject.Inject;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.domain.Location;
import org.jclouds.openstack.nova.v2_0.domain.Image;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.ImageInRegion;

public class ImageInRegionToImage
implements Function<ImageInRegion, Image> {
    private final Map<Image.Status, Image.Status> toPortableImageStatus;
    private final Function<org.jclouds.openstack.nova.v2_0.domain.Image, OperatingSystem> imageToOs;
    private final Supplier<Map<String, Location>> locationIndex;

    @Inject
    public ImageInRegionToImage(Map<Image.Status, Image.Status> toPortableImageStatus, Function<org.jclouds.openstack.nova.v2_0.domain.Image, OperatingSystem> imageToOs, Supplier<Map<String, Location>> locationIndex) {
        this.toPortableImageStatus = Preconditions.checkNotNull(toPortableImageStatus, "toPortableImageStatus");
        this.imageToOs = Preconditions.checkNotNull(imageToOs, "imageToOs");
        this.locationIndex = Preconditions.checkNotNull(locationIndex, "locationIndex");
    }

    @Override
    public Image apply(ImageInRegion imageInRegion) {
        Location location = this.locationIndex.get().get(imageInRegion.getRegion());
        Preconditions.checkState(location != null, "location %s not in locationIndex: %s", (Object)imageInRegion.getRegion(), this.locationIndex.get());
        org.jclouds.openstack.nova.v2_0.domain.Image image = imageInRegion.getImage();
        return ((ImageBuilder)new ImageBuilder().id(imageInRegion.slashEncode()).providerId(image.getId()).name(image.getName()).userMetadata((Map)image.getMetadata())).operatingSystem(this.imageToOs.apply(image)).description(image.getName()).location(location).status(this.toPortableImageStatus.get((Object)image.getStatus())).build();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).toString();
    }
}

