/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.inject.Named;
import org.jclouds.javax.annotation.Nullable;

public class HostAggregate {
    private final String id;
    private final String name;
    @Named(value="availability_zone")
    private final String availabilityZone;
    private final Set<String> hosts;
    @Named(value="operational_state")
    private final String state;
    @Named(value="created_at")
    private final Date created;
    @Named(value="updated_at")
    private final Optional<Date> updated;
    private final Map<String, String> metadata;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromHostAggregate(this);
    }

    @ConstructorProperties(value={"id", "name", "availability_zone", "hosts", "operational_state", "created_at", "updated_at", "metadata"})
    protected HostAggregate(String id, String name, @Nullable String availabilityZone, @Nullable Set<String> hosts, @Nullable String state, Date created, @Nullable Date updated, @Nullable Map<String, String> metadata) {
        this.id = Preconditions.checkNotNull(id, "id");
        this.name = Preconditions.checkNotNull(name, "name");
        this.availabilityZone = availabilityZone;
        this.hosts = hosts == null ? ImmutableSet.of() : ImmutableSet.copyOf(hosts);
        this.state = state;
        this.created = Preconditions.checkNotNull(created, "created");
        this.updated = Optional.fromNullable(updated);
        this.metadata = metadata == null ? ImmutableMap.of() : ImmutableMap.copyOf(metadata);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public Set<String> getHosts() {
        return this.hosts;
    }

    public String getState() {
        return this.state;
    }

    public Date getCreated() {
        return this.created;
    }

    public Optional<Date> getUpdated() {
        return this.updated;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public int hashCode() {
        return Objects.hashCode(this.id, this.name, this.availabilityZone, this.hosts, this.state, this.created, this.updated, this.metadata);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HostAggregate that = (HostAggregate)HostAggregate.class.cast(obj);
        return Objects.equal(this.id, that.id) && Objects.equal(this.name, that.name) && Objects.equal(this.availabilityZone, that.availabilityZone) && Objects.equal(this.hosts, that.hosts) && Objects.equal(this.state, that.state) && Objects.equal(this.created, that.created) && Objects.equal(this.updated, that.updated) && Objects.equal(this.metadata, that.metadata);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper(this).add("id", this.id).add("name", this.name).add("availabilityZone", this.availabilityZone).add("hosts", this.hosts).add("state", this.state).add("created", this.created).add("updated", this.updated).add("metadata", this.metadata);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String id;
        protected String name;
        protected String availabilityZone;
        protected Set<String> hosts = ImmutableSet.of();
        protected String state;
        protected Date created;
        protected Date updated;
        protected Map<String, String> metadata = ImmutableMap.of();

        protected abstract T self();

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this.self();
        }

        public T hosts(Set<String> hosts) {
            this.hosts = ImmutableSet.copyOf((Collection)Preconditions.checkNotNull(hosts, "hosts"));
            return this.self();
        }

        public T hosts(String ... in) {
            return this.hosts(ImmutableSet.copyOf(in));
        }

        public T state(String state) {
            this.state = state;
            return this.self();
        }

        public T created(Date created) {
            this.created = created;
            return this.self();
        }

        public T updated(Date updated) {
            this.updated = updated;
            return this.self();
        }

        public T metadata(Map<String, String> metadata) {
            this.metadata = ImmutableMap.copyOf(Preconditions.checkNotNull(metadata, "metadata"));
            return this.self();
        }

        public HostAggregate build() {
            return new HostAggregate(this.id, this.name, this.availabilityZone, this.hosts, this.state, this.created, this.updated, this.metadata);
        }

        public T fromHostAggregate(HostAggregate in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id(in.getId())).name(in.getName())).availabilityZone(in.getAvailabilityZone())).hosts(in.getHosts())).state(in.getState())).created(in.getCreated())).updated(in.getUpdated().get())).metadata(in.getMetadata());
        }
    }
}

