/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.inject.Named;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.nova.v2_0.domain.Address;
import org.jclouds.openstack.nova.v2_0.domain.ServerExtendedAttributes;
import org.jclouds.openstack.nova.v2_0.domain.ServerExtendedStatus;
import org.jclouds.openstack.v2_0.domain.Link;
import org.jclouds.openstack.v2_0.domain.Resource;

public class Server
extends Resource {
    public static final String DISK_CONFIG_MANUAL = "MANUAL";
    public static final String DISK_CONFIG_AUTO = "AUTO";
    private final String uuid;
    @Named(value="tenant_id")
    private final String tenantId;
    @Named(value="user_id")
    private final String userId;
    private final Date updated;
    private final Date created;
    private final String hostId;
    private final String accessIPv4;
    private final String accessIPv6;
    private final Status status;
    private final Resource image;
    private final Resource flavor;
    @Named(value="key_name")
    private final String keyName;
    @Named(value="config_drive")
    private final String configDrive;
    private final Multimap<String, Address> addresses;
    private final Map<String, String> metadata;
    private final Optional<ServerExtendedStatus> extendedStatus;
    private final Optional<ServerExtendedAttributes> extendedAttributes;
    @Named(value="OS-DCF:diskConfig")
    private final Optional<String> diskConfig;
    @Named(value="OS-EXT-AZ:availability_zone")
    private final Optional<String> availabilityZone;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromServer(this);
    }

    @ConstructorProperties(value={"id", "name", "links", "uuid", "tenant_id", "user_id", "updated", "created", "hostId", "accessIPv4", "accessIPv6", "status", "image", "flavor", "key_name", "config_drive", "addresses", "metadata", "extendedStatus", "extendedAttributes", "OS-DCF:diskConfig", "OS-EXT-AZ:availability_zone"})
    protected Server(String id, @Nullable String name, Set<Link> links, @Nullable String uuid, String tenantId, String userId, @Nullable Date updated, Date created, @Nullable String hostId, @Nullable String accessIPv4, @Nullable String accessIPv6, Status status, @Nullable Resource image, Resource flavor, @Nullable String keyName, @Nullable String configDrive, Multimap<String, Address> addresses, Map<String, String> metadata, @Nullable ServerExtendedStatus extendedStatus, @Nullable ServerExtendedAttributes extendedAttributes, @Nullable String diskConfig, @Nullable String availabilityZone) {
        super(id, name, links);
        this.uuid = uuid;
        this.tenantId = Preconditions.checkNotNull(tenantId, "tenantId");
        this.userId = Preconditions.checkNotNull(userId, "userId");
        this.updated = updated;
        this.created = Preconditions.checkNotNull(created, "created");
        this.hostId = Strings.emptyToNull(hostId);
        this.accessIPv4 = Strings.emptyToNull(accessIPv4);
        this.accessIPv6 = Strings.emptyToNull(accessIPv6);
        this.status = Preconditions.checkNotNull(status, "status");
        this.image = image;
        this.flavor = Preconditions.checkNotNull(flavor, "flavor");
        this.keyName = Strings.emptyToNull(keyName);
        this.configDrive = Strings.emptyToNull(configDrive);
        this.addresses = ImmutableMultimap.copyOf(Preconditions.checkNotNull(addresses, "addresses"));
        this.metadata = ImmutableMap.copyOf(Preconditions.checkNotNull(metadata, "metadata"));
        this.extendedStatus = Optional.fromNullable(extendedStatus);
        this.extendedAttributes = Optional.fromNullable(extendedAttributes);
        this.diskConfig = Optional.fromNullable(diskConfig);
        this.availabilityZone = Optional.fromNullable(availabilityZone);
    }

    @Nullable
    public String getUuid() {
        return this.uuid;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getUserId() {
        return this.userId;
    }

    @Nullable
    public Date getUpdated() {
        return this.updated;
    }

    public Date getCreated() {
        return this.created;
    }

    @Nullable
    public String getHostId() {
        return this.hostId;
    }

    @Nullable
    public String getAccessIPv4() {
        return this.accessIPv4;
    }

    @Nullable
    public String getAccessIPv6() {
        return this.accessIPv6;
    }

    public Status getStatus() {
        return this.status;
    }

    @Nullable
    public String getConfigDrive() {
        return this.configDrive;
    }

    public Resource getImage() {
        return this.image;
    }

    public Resource getFlavor() {
        return this.flavor;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public Multimap<String, Address> getAddresses() {
        return this.addresses;
    }

    @Nullable
    public String getKeyName() {
        return this.keyName;
    }

    public Optional<ServerExtendedStatus> getExtendedStatus() {
        return this.extendedStatus;
    }

    public Optional<ServerExtendedAttributes> getExtendedAttributes() {
        return this.extendedAttributes;
    }

    public Optional<String> getDiskConfig() {
        return this.diskConfig;
    }

    @Nullable
    public Optional<String> getAvailabilityZone() {
        return this.availabilityZone;
    }

    @Override
    protected MoreObjects.ToStringHelper string() {
        return super.string().add("uuid", this.uuid).add("tenantId", this.tenantId).add("userId", this.userId).add("updated", this.updated).add("created", this.created).add("hostId", this.hostId).add("accessIPv4", this.accessIPv4).add("accessIPv6", this.accessIPv6).add("status", (Object)this.status).add("image", this.image).add("flavor", this.flavor).add("keyName", this.keyName).add("configDrive", this.configDrive).add("addresses", this.addresses).add("metadata", this.metadata).add("extendedStatus", this.extendedStatus).add("extendedAttributes", this.extendedAttributes).add("diskConfig", this.diskConfig).add("availabilityZone", this.availabilityZone);
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>>
    extends Resource.Builder<T> {
        protected String uuid;
        protected String tenantId;
        protected String userId;
        protected Date updated;
        protected Date created;
        protected String hostId;
        protected String accessIPv4;
        protected String accessIPv6;
        protected Status status;
        protected Resource image;
        protected Resource flavor;
        protected String keyName;
        protected String configDrive;
        protected Multimap<String, Address> addresses = ImmutableMultimap.of();
        protected Map<String, String> metadata = ImmutableMap.of();
        protected ServerExtendedStatus extendedStatus;
        protected ServerExtendedAttributes extendedAttributes;
        protected String diskConfig;
        protected String availabilityZone;

        public T uuid(String uuid) {
            this.uuid = uuid;
            return (T)((Builder)this.self());
        }

        public T tenantId(String tenantId) {
            this.tenantId = tenantId;
            return (T)((Builder)this.self());
        }

        public T userId(String userId) {
            this.userId = userId;
            return (T)((Builder)this.self());
        }

        public T updated(Date updated) {
            this.updated = updated;
            return (T)((Builder)this.self());
        }

        public T created(Date created) {
            this.created = created;
            return (T)((Builder)this.self());
        }

        public T hostId(String hostId) {
            this.hostId = hostId;
            return (T)((Builder)this.self());
        }

        public T accessIPv4(String accessIPv4) {
            this.accessIPv4 = accessIPv4;
            return (T)((Builder)this.self());
        }

        public T accessIPv6(String accessIPv6) {
            this.accessIPv6 = accessIPv6;
            return (T)((Builder)this.self());
        }

        public T status(Status status) {
            this.status = status;
            return (T)((Builder)this.self());
        }

        public T image(Resource image) {
            this.image = image;
            return (T)((Builder)this.self());
        }

        public T flavor(Resource flavor) {
            this.flavor = flavor;
            return (T)((Builder)this.self());
        }

        public T keyName(String keyName) {
            this.keyName = keyName;
            return (T)((Builder)this.self());
        }

        public T configDrive(String configDrive) {
            this.configDrive = configDrive;
            return (T)((Builder)this.self());
        }

        public T addresses(Multimap<String, Address> addresses) {
            this.addresses = addresses;
            return (T)((Builder)this.self());
        }

        public T metadata(Map<String, String> metadata) {
            this.metadata = ImmutableMap.copyOf(Preconditions.checkNotNull(metadata, "metadata"));
            return (T)((Builder)this.self());
        }

        public T extendedStatus(ServerExtendedStatus extendedStatus) {
            this.extendedStatus = extendedStatus;
            return (T)((Builder)this.self());
        }

        public T extendedAttributes(ServerExtendedAttributes extendedAttributes) {
            this.extendedAttributes = extendedAttributes;
            return (T)((Builder)this.self());
        }

        public T diskConfig(String diskConfig) {
            this.diskConfig = diskConfig;
            return (T)((Builder)this.self());
        }

        public T availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return (T)((Builder)this.self());
        }

        @Override
        public Server build() {
            return new Server(this.id, this.name, this.links, this.uuid, this.tenantId, this.userId, this.updated, this.created, this.hostId, this.accessIPv4, this.accessIPv6, this.status, this.image, this.flavor, this.keyName, this.configDrive, this.addresses, this.metadata, this.extendedStatus, this.extendedAttributes, this.diskConfig, this.availabilityZone);
        }

        public T fromServer(Server in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)super.fromResource(in)).uuid(in.getUuid())).tenantId(in.getTenantId())).userId(in.getUserId())).updated(in.getUpdated())).created(in.getCreated())).hostId(in.getHostId())).accessIPv4(in.getAccessIPv4())).accessIPv6(in.getAccessIPv6())).status(in.getStatus())).image(in.getImage())).flavor(in.getFlavor())).keyName(in.getKeyName())).configDrive(in.getConfigDrive())).addresses(in.getAddresses())).metadata(in.getMetadata())).extendedStatus(in.getExtendedStatus().orNull())).extendedAttributes(in.getExtendedAttributes().orNull())).diskConfig(in.getDiskConfig().orNull())).availabilityZone(in.getAvailabilityZone().orNull());
        }
    }

    public static enum Status {
        ACTIVE,
        BUILD,
        REBUILD,
        SUSPENDED,
        PAUSED,
        RESIZE,
        VERIFY_RESIZE,
        REVERT_RESIZE,
        PASSWORD,
        REBOOT,
        HARD_REBOOT,
        DELETED,
        UNKNOWN,
        ERROR,
        STOPPED,
        UNRECOGNIZED,
        MIGRATING,
        SHUTOFF,
        RESCUE,
        SOFT_DELETED,
        SHELVED,
        SHELVED_OFFLOADED;


        public String value() {
            return this.name();
        }

        public static Status fromValue(String v) {
            try {
                return Status.valueOf(v.replaceAll("\\(.*", ""));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

