/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.packet.domain;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.jclouds.json.SerializedNames;
import org.jclouds.packet.domain.AutoValue_Specs;
import org.jclouds.packet.domain.AutoValue_Specs_CPU;
import org.jclouds.packet.domain.AutoValue_Specs_Drive;
import org.jclouds.packet.domain.AutoValue_Specs_Memory;
import org.jclouds.packet.domain.AutoValue_Specs_NIC;

public abstract class Specs {
    public abstract List<CPU> cpus();

    public abstract Memory memory();

    public abstract List<Drive> drives();

    public abstract List<NIC> nics();

    public abstract Map<String, Object> features();

    @SerializedNames(value={"cpus", "memory", "drives", "nics", "features"})
    public static Specs create(List<CPU> cpus, Memory memory, List<Drive> drives, List<NIC> nics, Map<String, Object> features) {
        return new AutoValue_Specs(cpus == null ? ImmutableList.of() : ImmutableList.copyOf(cpus), memory, drives == null ? ImmutableList.of() : ImmutableList.copyOf(drives), nics == null ? ImmutableList.of() : ImmutableList.copyOf(nics), features == null ? ImmutableMap.of() : ImmutableMap.copyOf(features));
    }

    Specs() {
    }

    public static abstract class Memory {
        public abstract String total();

        @SerializedNames(value={"total"})
        public static Memory create(String total) {
            return new AutoValue_Specs_Memory(total);
        }
    }

    public static abstract class CPU {
        public abstract Integer count();

        public abstract String type();

        @SerializedNames(value={"count", "type"})
        public static CPU create(Integer count, String type) {
            return new AutoValue_Specs_CPU(count, type);
        }
    }

    public static abstract class Drive {
        public abstract Integer count();

        public abstract String size();

        public abstract String type();

        @SerializedNames(value={"count", "size", "type"})
        public static Drive create(Integer count, String size, String type) {
            return new AutoValue_Specs_Drive(count, size, type);
        }
    }

    public static abstract class NIC {
        public abstract Integer count();

        public abstract String type();

        @SerializedNames(value={"count", "type"})
        public static NIC create(Integer count, String type) {
            return new AutoValue_Specs_NIC(count, type);
        }
    }
}

