/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.profitbricks.http.parser.firewall;

import com.google.inject.Inject;
import java.util.List;
import org.jclouds.profitbricks.domain.Firewall;
import org.jclouds.profitbricks.http.parser.firewall.BaseFirewallResponseHandler;
import org.jclouds.profitbricks.http.parser.firewall.rule.FirewallRuleListResponseHandler;
import org.xml.sax.SAXException;

public class FirewallResponseHandler
extends BaseFirewallResponseHandler<Firewall> {
    private boolean done = false;

    @Inject
    FirewallResponseHandler(FirewallRuleListResponseHandler firewallRuleListResponseHandler) {
        super(firewallRuleListResponseHandler);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.done) {
            return;
        }
        if (this.useFirewallRuleParser) {
            this.firewallRuleListResponseHandler.endElement(uri, localName, qName);
        } else {
            this.setPropertyOnEndTag(qName);
            if ("return".equals(qName)) {
                this.done = true;
                this.builder.rules((List<Firewall.Rule>)this.firewallRuleListResponseHandler.getResult());
            }
            this.clearTextBuffer();
        }
        if ("firewallRules".equals(qName)) {
            this.useFirewallRuleParser = false;
        }
    }

    @Override
    public void reset() {
        this.builder = Firewall.builder();
    }

    @Override
    public Firewall getResult() {
        return this.builder.build();
    }
}

