/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.profitbricks.http.parser.ipblock;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.List;
import org.jclouds.profitbricks.domain.IpBlock;
import org.jclouds.profitbricks.http.parser.ipblock.BaseIpBlockResponseHandler;
import org.jclouds.profitbricks.http.parser.publicip.PublicIpListResponseHandler;
import org.xml.sax.SAXException;

public class IpBlockListResponseHandler
extends BaseIpBlockResponseHandler<List<IpBlock>> {
    private final List<IpBlock> ipBlocks = Lists.newArrayList();

    @Inject
    IpBlockListResponseHandler(PublicIpListResponseHandler publicIpListResponseHandler) {
        super(publicIpListResponseHandler);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.usePublicIpListParser) {
            this.publicIpListResponseHandler.endElement(uri, localName, qName);
        } else {
            this.setPropertyOnEndTag(qName);
            if ("return".equals(qName)) {
                this.ipBlocks.add(this.builder.publicIps((List<IpBlock.PublicIp>)this.publicIpListResponseHandler.getResult()).build());
                this.publicIpListResponseHandler.reset();
                this.builder = IpBlock.builder();
            }
            this.clearTextBuffer();
        }
        if ("publicIps".equals(qName)) {
            this.usePublicIpListParser = false;
        }
    }

    @Override
    public List<IpBlock> getResult() {
        return this.ipBlocks;
    }
}

