/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.profitbricks.util;

import com.google.common.base.Strings;
import com.google.common.net.InetAddresses;
import java.util.List;
import java.util.regex.Pattern;
import org.jclouds.profitbricks.domain.Firewall;
import org.jclouds.profitbricks.util.MacAddresses;

public final class Preconditions {
    private static final Pattern INVALID_CHARS = Pattern.compile("^.*[@/\\|'`\u2019^].*$");
    private static final int VALID_PASSWORD_MIN_LENGTH = 8;
    private static final int VALID_PASSWORD_MAX_LENGTH = 50;
    private static final String PASSWORD_FORMAT = String.format("[a-zA-Z0-9][^iIloOwWyYzZ10]{%d,%d}", 7, 50);
    private static final Pattern PASSWORD_PATTERN = Pattern.compile(PASSWORD_FORMAT);

    public static void checkInvalidChars(String name) {
        com.google.common.base.Preconditions.checkArgument(!Strings.isNullOrEmpty(name), "Name is required.");
        com.google.common.base.Preconditions.checkArgument(!INVALID_CHARS.matcher(name).matches(), "Name must not contain any of: @ / \\ | ' ` \u2019 ^");
    }

    public static void checkIp(String ip) {
        com.google.common.base.Preconditions.checkArgument(InetAddresses.isInetAddress(ip), "IP '%s' is invalid", (Object)ip);
    }

    public static void checkIps(List<String> ips) {
        com.google.common.base.Preconditions.checkNotNull(ips, "Null ip list");
        for (String ip : ips) {
            Preconditions.checkIp(ip);
        }
    }

    public static void checkPortRange(Integer portRangeStart, Integer portRangeEnd, Firewall.Protocol protocol) {
        com.google.common.base.Preconditions.checkArgument(!(portRangeEnd == null ^ portRangeStart == null), "Port range must be both present or null");
        if (portRangeEnd != null) {
            com.google.common.base.Preconditions.checkArgument(protocol == Firewall.Protocol.TCP || protocol == Firewall.Protocol.UDP, "Port range can only be set for TCP or UDP");
            com.google.common.base.Preconditions.checkArgument(portRangeEnd > portRangeStart, "portRangeEnd must be greater than portRangeStart");
            com.google.common.base.Preconditions.checkArgument(portRangeEnd >= 1 && portRangeEnd <= 65534, "Port range end must be 1 to 65534");
            com.google.common.base.Preconditions.checkArgument(portRangeStart >= 1 && portRangeStart <= 65534, "Port range start must be 1 to 65534");
        }
    }

    public static void checkMacAddress(String macAddress) {
        com.google.common.base.Preconditions.checkArgument(MacAddresses.isMacAddress(macAddress), "MAC must match pattern 'aa:bb:cc:dd:ee:ff'");
    }

    public static void checkIcmp(Integer icmpType, Integer icmpCode, Firewall.Protocol protocol) {
        com.google.common.base.Preconditions.checkNotNull(protocol, "Protocol can't be null");
        if (protocol == Firewall.Protocol.ICMP) {
            if (icmpType != null) {
                com.google.common.base.Preconditions.checkArgument(icmpType >= 1 && icmpType <= 254, "ICMP type must be 1 to 254");
            }
            if (icmpCode != null) {
                com.google.common.base.Preconditions.checkArgument(icmpCode >= 1 && icmpCode <= 254, "ICMP code must be 1 to 254");
            }
        }
    }

    public static void checkLanId(Integer id) {
        com.google.common.base.Preconditions.checkArgument(id >= 0, "LAN ID must be non-negative");
    }

    public static void checkCores(Integer cores) {
        com.google.common.base.Preconditions.checkArgument(cores > 0, "Number of cores must be atleast 1.");
    }

    public static void checkRam(Integer ram, Boolean isRamHotPlug) {
        int minRam = isRamHotPlug == null || isRamHotPlug == false ? 256 : 1024;
        com.google.common.base.Preconditions.checkArgument(ram >= minRam && ram % 256 == 0, "RAM must be multiples of 256 with minimum of 256 MB (1024 MB if ramHotPlug is enabled)");
    }

    public static void checkSize(Float size) {
        com.google.common.base.Preconditions.checkArgument(size.floatValue() > 1.0f, "Storage size must be > 1GB");
    }

    public static void checkPassword(String password) {
        com.google.common.base.Preconditions.checkArgument(PASSWORD_PATTERN.matcher(password).matches(), "Password must be between 8 and 50 characters, only a-z, A-Z, 0-9 without  characters i, I, l, o, O, w, W, y, Y, z, Z and 1, 0");
    }
}

