/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.http.master;

import es.bsc.compss.comm.CommAdaptor;
import es.bsc.compss.exceptions.ConstructConfigurationException;
import es.bsc.compss.http.master.HTTPInstance;
import es.bsc.compss.http.master.HTTPJob;
import es.bsc.compss.types.COMPSsWorker;
import es.bsc.compss.types.NodeMonitor;
import es.bsc.compss.types.data.operation.DataOperation;
import es.bsc.compss.types.resources.configuration.Configuration;
import es.bsc.compss.types.resources.configuration.HTTPConfiguration;
import es.bsc.compss.types.resources.jaxb.HttpType;
import es.bsc.compss.types.uri.MultiURI;
import es.bsc.conn.types.StarterCommand;
import java.util.LinkedList;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HTTPAdaptor
implements CommAdaptor {
    public static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Communication");

    public void init() {
        try {
            HTTPJob.init();
        }
        catch (Exception e) {
            LOGGER.error("Can not initialize HTTP Adaptor");
        }
    }

    public Configuration constructConfiguration(Map<String, Object> projectProperties, Map<String, Object> resourcesProperties) throws ConstructConfigurationException {
        es.bsc.compss.types.project.jaxb.HttpType hProject = (es.bsc.compss.types.project.jaxb.HttpType)projectProperties.get("Http");
        HttpType hResources = (HttpType)resourcesProperties.get("Http");
        String baseUrl = null;
        if (hProject != null) {
            baseUrl = hProject.getBaseUrl();
        } else if (hResources != null) {
            baseUrl = hResources.getBaseUrl();
        } else {
            throw new ConstructConfigurationException("Cannot configure http service because no URL provided");
        }
        HTTPConfiguration config = new HTTPConfiguration(this.getClass().getName(), baseUrl);
        if (hProject != null) {
            config.setLimitOfTasks(hProject.getLimitOfTasks().intValue());
        }
        if (hResources != null) {
            config.setServices(hResources.getServiceName());
        }
        return config;
    }

    public StarterCommand getStarterCommand(String workerName, int workerPort, String masterName, String workingDir, String installDir, String appDir, String classpathFromFile, String pythonpathFromFile, String libPathFromFile, String envScriptFromFile, String pythonInterpreterFromFile, int totalCPU, int totalGPU, int totalFPGA, int limitOfTasks, String hostId) {
        return null;
    }

    public COMPSsWorker initWorker(Configuration config, NodeMonitor monitor) {
        HTTPConfiguration httpConfiguration = (HTTPConfiguration)config;
        String httpName = "http\u1e80orker";
        LOGGER.debug("Init HTTP Worker named " + httpName);
        return new HTTPInstance(httpConfiguration, monitor, httpName);
    }

    public void stop() {
        HTTPJob.end();
    }

    public LinkedList<DataOperation> getPending() {
        return null;
    }

    public void stopSubmittedJobs() {
    }

    public void completeMasterURI(MultiURI u) {
    }
}

