/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch.jce;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.SignatureECDSA;
import com.jcraft.jsch.jce.Util;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;

abstract class SignatureECDSAN
implements SignatureECDSA {
    Signature signature;
    KeyFactory keyFactory;

    SignatureECDSAN() {
    }

    abstract String getName();

    @Override
    public void init() throws Exception {
        String name = this.getName();
        String foo = "SHA256withECDSA";
        if (name.equals("ecdsa-sha2-nistp384")) {
            foo = "SHA384withECDSA";
        } else if (name.equals("ecdsa-sha2-nistp521")) {
            foo = "SHA512withECDSA";
        }
        this.signature = Signature.getInstance(foo);
        this.keyFactory = KeyFactory.getInstance("EC");
    }

    @Override
    public void setPubKey(byte[] r, byte[] s) throws Exception {
        r = SignatureECDSAN.insert0(r);
        s = SignatureECDSAN.insert0(s);
        String name = "secp256r1";
        if (r.length >= 64) {
            name = "secp521r1";
        } else if (r.length >= 48) {
            name = "secp384r1";
        }
        AlgorithmParameters param = AlgorithmParameters.getInstance("EC");
        param.init(new ECGenParameterSpec(name));
        ECParameterSpec ecparam = param.getParameterSpec(ECParameterSpec.class);
        ECPoint w = new ECPoint(new BigInteger(1, r), new BigInteger(1, s));
        PublicKey pubKey = this.keyFactory.generatePublic(new ECPublicKeySpec(w, ecparam));
        this.signature.initVerify(pubKey);
    }

    @Override
    public void setPrvKey(byte[] d) throws Exception {
        d = SignatureECDSAN.insert0(d);
        String name = "secp256r1";
        if (d.length >= 64) {
            name = "secp521r1";
        } else if (d.length >= 48) {
            name = "secp384r1";
        }
        AlgorithmParameters param = AlgorithmParameters.getInstance("EC");
        param.init(new ECGenParameterSpec(name));
        ECParameterSpec ecparam = param.getParameterSpec(ECParameterSpec.class);
        BigInteger _d = new BigInteger(1, d);
        PrivateKey prvKey = this.keyFactory.generatePrivate(new ECPrivateKeySpec(_d, ecparam));
        this.signature.initSign(prvKey);
    }

    @Override
    public byte[] sign() throws Exception {
        byte[] sig = this.signature.sign();
        if (sig[0] == 48 && (sig[1] + 2 == sig.length || (sig[1] & 0x80) != 0 && (sig[2] & 0xFF) + 3 == sig.length)) {
            int index = 3;
            if ((sig[1] & 0x80) != 0 && (sig[2] & 0xFF) + 3 == sig.length) {
                index = 4;
            }
            byte[] r = new byte[sig[index]];
            byte[] s = new byte[sig[index + 2 + sig[index]]];
            System.arraycopy(sig, index + 1, r, 0, r.length);
            System.arraycopy(sig, index + 3 + sig[index], s, 0, s.length);
            r = SignatureECDSAN.chop0(r);
            s = SignatureECDSAN.chop0(s);
            Buffer buf2 = new Buffer();
            buf2.putMPInt(r);
            buf2.putMPInt(s);
            sig = new byte[buf2.getLength()];
            buf2.setOffSet(0);
            buf2.getByte(sig);
        }
        return sig;
    }

    @Override
    public void update(byte[] foo) throws Exception {
        this.signature.update(foo);
    }

    @Override
    public boolean verify(byte[] sig) throws Exception {
        if (sig[0] != 48 || sig[1] + 2 != sig.length && ((sig[1] & 0x80) == 0 || (sig[2] & 0xFF) + 3 != sig.length)) {
            Buffer b = new Buffer(sig);
            b.getString();
            b.getInt();
            byte[] r = b.getMPInt();
            byte[] s = b.getMPInt();
            r = SignatureECDSAN.trimLeadingZeros(SignatureECDSAN.insert0(r));
            s = SignatureECDSAN.trimLeadingZeros(SignatureECDSAN.insert0(s));
            byte[] asn1 = null;
            if (r.length < 64) {
                asn1 = new byte[6 + r.length + s.length];
                asn1[0] = 48;
                asn1[1] = (byte)(4 + r.length + s.length);
                asn1[2] = 2;
                asn1[3] = (byte)r.length;
                System.arraycopy(r, 0, asn1, 4, r.length);
                asn1[r.length + 4] = 2;
                asn1[r.length + 5] = (byte)s.length;
                System.arraycopy(s, 0, asn1, 6 + r.length, s.length);
            } else {
                asn1 = new byte[6 + r.length + s.length + 1];
                asn1[0] = 48;
                asn1[1] = -127;
                asn1[2] = (byte)(4 + r.length + s.length);
                asn1[3] = 2;
                asn1[4] = (byte)r.length;
                System.arraycopy(r, 0, asn1, 5, r.length);
                asn1[r.length + 5] = 2;
                asn1[r.length + 6] = (byte)s.length;
                System.arraycopy(s, 0, asn1, 7 + r.length, s.length);
            }
            sig = asn1;
        }
        return this.signature.verify(sig);
    }

    private static byte[] insert0(byte[] buf2) {
        if ((buf2[0] & 0x80) == 0) {
            return buf2;
        }
        byte[] tmp = new byte[buf2.length + 1];
        System.arraycopy(buf2, 0, tmp, 1, buf2.length);
        Util.bzero(buf2);
        return tmp;
    }

    private static byte[] chop0(byte[] buf2) {
        if (buf2[0] != 0) {
            return buf2;
        }
        byte[] tmp = new byte[buf2.length - 1];
        System.arraycopy(buf2, 1, tmp, 0, tmp.length);
        Util.bzero(buf2);
        return tmp;
    }

    private static byte[] trimLeadingZeros(byte[] buf2) {
        int i;
        if (buf2.length < 2) {
            return buf2;
        }
        for (i = 0; i < buf2.length - 1 && buf2[i] == 0 && (buf2[i + 1] & 0x80) == 0; ++i) {
        }
        if (i == 0) {
            return buf2;
        }
        byte[] tmp = new byte[buf2.length - i];
        System.arraycopy(buf2, i, tmp, 0, tmp.length);
        Util.bzero(buf2);
        return tmp;
    }
}

