/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.gos.master;

import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.SftpException;
import es.bsc.compss.exceptions.InitNodeException;
import es.bsc.compss.gos.master.GOSAdaptor;
import es.bsc.compss.gos.master.GOSCopy;
import es.bsc.compss.gos.master.GOSJob;
import es.bsc.compss.gos.master.GOSUri;
import es.bsc.compss.gos.master.configuration.GOSConfiguration;
import es.bsc.compss.gos.master.exceptions.GOSWarningException;
import es.bsc.compss.gos.master.monitoring.GOSMonitoring;
import es.bsc.compss.gos.master.sshutils.SSHHost;
import es.bsc.compss.types.COMPSsWorker;
import es.bsc.compss.types.NodeMonitor;
import es.bsc.compss.types.TaskDescription;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.data.Transferable;
import es.bsc.compss.types.data.listener.EventListener;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.data.location.ProtocolType;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.job.Job;
import es.bsc.compss.types.job.JobListener;
import es.bsc.compss.types.resources.ExecutorShutdownListener;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.types.resources.ResourceDescription;
import es.bsc.compss.types.resources.ShutdownListener;
import es.bsc.compss.types.uri.MultiURI;
import es.bsc.compss.types.uri.SimpleURI;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GOSWorkerNode
extends COMPSsWorker {
    private static final String WORKER_SCRIPT_PATH = "Runtime" + File.separator + "scripts" + File.separator + "system" + File.separator + "adaptors" + File.separator + "gos" + File.separator;
    protected static final String BATCH_OUTPUT_DIR = "BatchOutput";
    protected static final String CANCEL_JOB_DIR = "CancelJobsScript";
    protected static final String SSH_RESPONSE_DIR = "JobsStatus";
    private static final String INIT_SCRIPT = "init.sh";
    private static final String END_SCRIPT = "clean.sh";
    private static final String COMPRESS_SCRIPT = "compressWorkingDir.sh";
    private static final String COMPRESS_FILENAME = "compressed-remote-files.tar";
    private final GOSConfiguration config;
    private final SSHHost host;
    private final GOSAdaptor adaptor;
    protected final Map<String, GOSJob> runningJobs;
    private final String dbgPrefix;
    private final List<NodeMonitor> monitorList = new ArrayList<NodeMonitor>();

    public GOSWorkerNode(NodeMonitor monitor, GOSConfiguration config, GOSAdaptor adaptor) {
        super(monitor);
        this.config = config;
        this.adaptor = adaptor;
        this.runningJobs = new HashMap<String, GOSJob>();
        this.host = config.getAdaptor().getHost(config.getUser(), config.getHost());
        this.dbgPrefix = "[GOSWorkerNode " + this.host.getFullHostName() + "] ";
        this.monitorList.add(monitor);
    }

    public GOSMonitoring getGosMonitoring() {
        return this.config.getMonitoring();
    }

    @Override
    public String getName() {
        return this.config.getHost();
    }

    @Override
    public void start() throws InitNodeException {
        LOGGER.debug(this.dbgPrefix + "Starting and creating sandbox directory");
        this.initWorkingDir();
    }

    private void initWorkingDir() throws InitNodeException {
        String initScriptPath = this.config.getInstallDir() + WORKER_SCRIPT_PATH + INIT_SCRIPT;
        String wkDir = this.config.getSandboxWorkingDir();
        String args = wkDir + " " + SSH_RESPONSE_DIR + " " + CANCEL_JOB_DIR + " " + BATCH_OUTPUT_DIR;
        LOGGER.info(this.dbgPrefix + "Init working directory. Command: " + initScriptPath + " " + args);
        this.host.executeStarterCommand(initScriptPath + " " + args);
    }

    @Override
    public void setInternalURI(MultiURI uri) {
        GOSUri gosUri = new GOSUri(this.config.getUser(), uri.getHost(), uri.getPath(), uri.getProtocol());
        uri.setInternalURI(GOSAdaptor.ID, gosUri);
    }

    @Override
    public Job<?> newJob(int taskId, TaskDescription taskParams, Implementation impl, Resource res, List<String> slaveWorkersNodeNames, JobListener listener, List<Integer> predecessors, Integer numSuccessors) {
        return new GOSJob(taskId, taskParams, impl, res, slaveWorkersNodeNames, listener, predecessors, numSuccessors);
    }

    @Override
    public void sendData(LogicalData srcData, DataLocation source, DataLocation target, LogicalData tgtData, Transferable reason, EventListener listener) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.info(this.dbgPrefix + "send data");
        }
        GOSCopy copy = new GOSCopy(srcData, source, target, tgtData, reason, listener, this, "send");
        this.config.getAdaptor().enqueueCopy(copy);
    }

    @Override
    public void obtainData(LogicalData srcData, DataLocation source, DataLocation target, LogicalData tgtData, Transferable reason, EventListener listener) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.info(this.dbgPrefix + "obtain data");
        }
        GOSCopy copy = new GOSCopy(srcData, source, target, tgtData, reason, listener, this, "obtain");
        this.config.getAdaptor().enqueueCopy(copy);
    }

    @Override
    public void enforceDataObtaining(Transferable reason, EventListener listener) {
    }

    @Override
    public void stop(ShutdownListener sl) {
        LOGGER.info(this.dbgPrefix + "Stopping WorkerNode.");
        sl.notifyEnd();
    }

    @Override
    public SimpleURI getCompletePath(DataType type, String name) {
        String path;
        switch (type) {
            case FILE_T: 
            case OBJECT_T: 
            case STREAM_T: 
            case EXTERNAL_STREAM_T: 
            case PSCO_T: 
            case EXTERNAL_PSCO_T: {
                path = ProtocolType.FILE_URI.getSchema() + this.config.getSandboxWorkingDir() + name;
                break;
            }
            case BINDING_OBJECT_T: {
                path = ProtocolType.BINDING_URI.getSchema() + this.config.getSandboxWorkingDir() + name;
                break;
            }
            default: {
                return null;
            }
        }
        return new SimpleURI(path);
    }

    @Override
    public void deleteTemporary() {
        LOGGER.info("GOSWorker deleteTemporary");
    }

    @Override
    public boolean generatePackage() {
        LOGGER.info("GOSWorker generatePackage");
        return false;
    }

    @Override
    public void shutdownExecutionManager(ExecutorShutdownListener sl) {
        LOGGER.info(this.dbgPrefix + "Shutting down execution manager of worker");
        String wk = this.getConfig().getSandboxWorkingDir();
        String ignoreBringFolder = "BatchOutput CancelJobsScript JobsStatus";
        boolean runEndCommand = true;
        if (LOGGER.isDebugEnabled()) {
            String uuid = System.getProperty("compss.uuid");
            String compressFolderPath = wk + this.config.getHost() + "-CF-" + uuid + ".tar";
            String compressCommand = this.config.getInstallDir() + WORKER_SCRIPT_PATH + COMPRESS_SCRIPT + " " + wk + " " + compressFolderPath + " " + ignoreBringFolder;
            try {
                this.host.executeBlockingCommand(compressCommand);
                String dst = System.getProperty("compss.log.dir") + COMPRESS_FILENAME;
                this.host.getFile(compressFolderPath, dst);
            }
            catch (GOSWarningException e) {
                LOGGER.warn(this.dbgPrefix + "Could not compress and/or bring remote working dir. Skipping directory removal", (Throwable)e);
                runEndCommand = false;
            }
            catch (JSchException e) {
                LOGGER.warn(this.dbgPrefix + "Error in during node shutdown.");
                runEndCommand = false;
            }
            catch (SftpException e) {
                LOGGER.warn(this.dbgPrefix + "Could not retrieve compress filed from remote machine.");
                runEndCommand = false;
            }
        }
        if (runEndCommand) {
            String endCommand = this.config.getInstallDir() + WORKER_SCRIPT_PATH + END_SCRIPT + " " + wk;
            try {
                this.host.executeBlockingCommand(endCommand);
            }
            catch (Exception e) {
                LOGGER.warn(this.dbgPrefix + "Could not cleanly remove remote working dir " + wk, (Throwable)e);
            }
        }
        this.host.releaseAllResources();
        sl.notifyEnd();
    }

    @Override
    public boolean generateWorkersDebugInfo() {
        LOGGER.info(this.dbgPrefix + "Worker debug files not supported on GOS Adaptor");
        return false;
    }

    @Override
    public void increaseComputingCapabilities(ResourceDescription description) {
    }

    @Override
    public void reduceComputingCapabilities(ResourceDescription description) {
    }

    @Override
    public void removeObsoletes(List<MultiURI> obsoletes) {
    }

    @Override
    public void verifyNodeIsRunning() {
    }

    @Override
    public String getUser() {
        return this.config.getUser();
    }

    @Override
    public String getClasspath() {
        return this.config.getClasspath();
    }

    @Override
    public String getPythonpath() {
        return this.config.getPythonpath();
    }

    @Override
    public void updateTaskCount(int processorCoreCount) {
    }

    @Override
    public void announceDestruction() {
    }

    @Override
    public void announceCreation() {
    }

    public GOSConfiguration getConfig() {
        return this.config;
    }

    public String getLibPath() {
        String libPath = this.config.getLibraryPath();
        libPath = libPath == null || libPath.isEmpty() ? "null" : libPath;
        return libPath;
    }

    public String getEnvScriptPath() {
        String envScriptPath = this.config.getEnvScript();
        envScriptPath = envScriptPath == null || envScriptPath.isEmpty() ? "null" : envScriptPath;
        return envScriptPath;
    }

    public void addRunningJob(GOSJob job) {
        this.runningJobs.put(job.getCompositeID(), job);
    }

    public void removeRunningJob(GOSJob job) {
        this.runningJobs.remove(job.getCompositeID());
    }

    public SSHHost getSSHHost() {
        return this.host;
    }

    @Override
    public String getAdaptor() {
        return GOSAdaptor.class.getCanonicalName();
    }

    @Override
    public Map<String, Object> getProjectProperties() {
        return this.config.getProjectProperty();
    }

    @Override
    public Map<String, Object> getResourcesProperties() {
        return this.config.getResourcesProperties();
    }

    public void addMonitor(NodeMonitor monitor) {
        LOGGER.debug(this.dbgPrefix + "Added monitor " + monitor.getClass());
        this.monitorList.add(monitor);
    }

    public GOSAdaptor getAdaptorClass() {
        return this.adaptor;
    }
}

