/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.gos.master.monitoring.jobmonitor;

import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.SftpException;
import es.bsc.compss.gos.master.GOSJob;
import es.bsc.compss.gos.master.GOSWorkerNode;
import es.bsc.compss.gos.master.exceptions.GOSWarningException;
import es.bsc.compss.gos.master.monitoring.jobmonitor.GOSHostsManager;
import es.bsc.compss.gos.master.sshutils.SSHChannel;
import es.bsc.compss.gos.master.sshutils.SSHHost;
import es.bsc.compss.types.job.JobEndStatus;
import es.bsc.compss.util.ErrorManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GOSHostBatchMonitor
implements GOSHostsManager {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Communication");
    private static final String CHECK_COMMAND_SCRIPT = GOSJob.SCRIPT_PATH + "check.sh";
    private final String installDir;
    final ConcurrentHashMap<String, GOSJob> activeJobs = new ConcurrentHashMap();
    HashSet<String> failedResponse = new HashSet();
    String responseDir;
    SSHHost host;

    GOSHostBatchMonitor(GOSJob job) {
        this.addJobMonitor(job);
        this.responseDir = job.getResponseDir();
        this.host = job.getSSHHost();
        this.installDir = ((GOSWorkerNode)job.getResourceNode()).getConfig().getInstallDir();
        assert (this.host != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void monitor() {
        if (this.activeJobs.isEmpty()) {
            return;
        }
        StringBuilder jobsId = new StringBuilder();
        for (GOSJob job : this.activeJobs.values()) {
            jobsId.append(job.getCompositeID()).append(" ");
            SSHChannel channel = job.getChannel();
            if (channel == null || !channel.isConnected() || channel.getExitStatus() == -1) continue;
            channel.disconnect();
            job.setChannel(null);
        }
        if (jobsId.toString().isEmpty()) {
            return;
        }
        String command = this.installDir + CHECK_COMMAND_SCRIPT + " " + this.responseDir + " " + jobsId;
        try {
            BufferedReader reader = this.host.executeCommand(command);
            while (reader.ready()) {
                boolean finished;
                String[] line = reader.readLine().split(" ");
                if (line.length < 3 || !(finished = this.treatJob(line[0], line[1], line[2]))) continue;
                ConcurrentHashMap<String, GOSJob> concurrentHashMap = this.activeJobs;
                synchronized (concurrentHashMap) {
                    this.activeJobs.remove(line[0]);
                }
            }
            return;
        }
        catch (JSchException | SftpException | IOException e) {
            LOGGER.error("Error in batch job monitor " + e);
            ErrorManager.error(e);
            return;
        }
        catch (GOSWarningException gOSWarningException) {
            // empty catch block
        }
    }

    private boolean treatJob(String id, String batchId, String status) throws JSchException, SftpException, IOException {
        GOSJob job = this.activeJobs.get(id);
        if (job == null) {
            return false;
        }
        boolean finished = false;
        String batchOutput = job.getBatchOutput();
        String jobID = job.getCompositeID();
        switch (status) {
            case "END": {
                finished = true;
                job.setBatchId(batchId);
                job.notifySuccess();
                break;
            }
            case "FAIL": {
                finished = true;
                job.setBatchId(batchId);
                job.notifyFailure(JobEndStatus.EXECUTION_FAILED);
                break;
            }
            case "SUBMIT": 
            case "LAUNCH": 
            case "RUN": {
                break;
            }
            default: {
                if (this.failedResponse.contains(id)) {
                    this.failedResponse.remove(id);
                    job.notifyFailure(JobEndStatus.SUBMISSION_FAILED);
                    break;
                }
                this.failedResponse.add(id);
            }
        }
        if (finished) {
            ArrayList<String> srcFiles = new ArrayList<String>();
            ArrayList<String> dstFiles = new ArrayList<String>();
            srcFiles.add(batchOutput + ".out");
            dstFiles.add(File.separator + GOSJob.JOBS_DIR + jobID + ".out");
            srcFiles.add(batchOutput + ".err");
            dstFiles.add(File.separator + GOSJob.JOBS_DIR + jobID + ".err");
            this.host.appendFiles(srcFiles, dstFiles);
        }
        return finished;
    }

    @Override
    public void addJobMonitor(GOSJob job) {
        this.activeJobs.put(job.getCompositeID(), job);
    }

    @Override
    public int countActiveJobs() {
        return this.activeJobs.size();
    }

    @Override
    public boolean existsRunningJobs() {
        return !this.activeJobs.isEmpty();
    }

    @Override
    public void shutdown() {
        for (GOSJob job : this.activeJobs.values()) {
            job.cancelJob();
        }
        this.activeJobs.clear();
    }
}

