/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.gos.master.monitoring.transfermonitor;

import com.jcraft.jsch.SftpException;
import es.bsc.compss.gos.master.GOSCopy;
import es.bsc.compss.gos.master.monitoring.transfermonitor.GOSTransferMonitor;
import es.bsc.compss.gos.master.monitoring.transfermonitor.sftpmonitor.GOSJschTransferMonitor;
import es.bsc.compss.gos.master.sshutils.SSHChannel;
import java.io.File;

public class GOSDifferentHostsTransfer
implements GOSTransferMonitor {
    private final GOSJschTransferMonitor transferMonitor;
    private final GOSCopy copy;
    private SSHChannel channelGet;
    private final SSHChannel channelSend;
    private final String dst;
    private final File tmpFile;
    private State state;

    public GOSDifferentHostsTransfer(GOSCopy copy, SSHChannel channelGet, SSHChannel channelSend, String src, String dst, File tmp, GOSJschTransferMonitor transferMonitor) {
        this.copy = copy;
        this.channelGet = channelGet;
        this.channelSend = channelSend;
        this.dst = dst;
        this.tmpFile = tmp;
        this.transferMonitor = transferMonitor;
        this.state = State.GET;
    }

    @Override
    public boolean monitor() {
        if (this.state.equals((Object)State.GET)) {
            if (this.transferMonitor.finished) {
                this.launchSend();
            }
            return false;
        }
        if (this.transferMonitor.finished) {
            this.releaseResources();
            this.copy.markAsFinished(this.transferMonitor.success);
            this.copy.notifyEnd();
            return true;
        }
        return false;
    }

    private void launchSend() {
        this.channelGet.disconnect();
        this.channelGet = null;
        this.state = State.SEND;
        GOSJschTransferMonitor m = new GOSJschTransferMonitor();
        try {
            this.channelSend.put(this.tmpFile.getPath(), this.dst, m);
        }
        catch (SftpException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getID() {
        return this.copy.getId();
    }

    @Override
    public void releaseResources() {
        boolean delete;
        if (this.channelSend != null) {
            this.channelSend.disconnect();
        }
        if (this.channelGet != null) {
            this.channelGet.disconnect();
        }
        if (delete = this.tmpFile.delete()) {
            this.copy.logWarn("Could not delete temporary file " + this.tmpFile.getPath() + ".");
        }
    }

    @Override
    public void shutdown() {
        this.releaseResources();
        this.copy.setState(GOSCopy.GOSCopyState.FAILED);
    }

    @Override
    public String getType() {
        return "DifferentHosts";
    }

    private static enum State {
        GET,
        SEND;

    }
}

