/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.scheduler.lookahead.successors.constraintsfifo;

import es.bsc.compss.scheduler.lookahead.LookaheadRS;
import es.bsc.compss.scheduler.types.AllocatableAction;
import es.bsc.compss.scheduler.types.Score;
import es.bsc.compss.types.TaskDescription;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.implementations.TaskType;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.types.resources.Worker;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import java.util.List;
import org.json.JSONObject;

public class ConstraintsFifoRS<T extends WorkerResourceDescription>
extends LookaheadRS<T> {
    public ConstraintsFifoRS(Worker<T> w, JSONObject resJSON, JSONObject implJSON) {
        super(w, resJSON, implJSON);
    }

    public Score generateBlockedScore(AllocatableAction action) {
        long priority = action.getPriority();
        long groupId = action.getGroupPriority();
        long resourceScore = 0L;
        long waitingScore = -action.getId();
        long implementationScore = 0L;
        return new Score(priority, groupId, resourceScore, waitingScore, implementationScore);
    }

    public Score generateResourceScore(AllocatableAction action, TaskDescription params, Score actionScore) {
        long priority = actionScore.getPriority();
        long groupId = action.getGroupPriority();
        long resource = this.calculateConstraintScore(params);
        long waitingScore = -action.getId();
        long implementationScore = 0L;
        return new Score(priority, groupId, resource, waitingScore, implementationScore);
    }

    protected long calculateConstraintScore(TaskDescription td) {
        if (td.getType() == TaskType.METHOD) {
            List implementations = td.getCoreElement().getImplementations();
            if (implementations != null && !implementations.isEmpty()) {
                MethodResourceDescription description = (MethodResourceDescription)((Implementation)implementations.get(0)).getRequirements();
                return description.getTotalCPUComputingUnits() * td.getNumNodes();
            }
            return 0L;
        }
        return 0L;
    }

    public Score getRunnableImplScore(AllocatableAction action, TaskDescription params, Implementation impl, Score resourceScore) {
        long priority = resourceScore.getPriority();
        long groupId = action.getGroupPriority();
        long resourcePriority = resourceScore.getResourceScore();
        long waitingScore = resourceScore.getWaitingScore();
        long implScore = 0L;
        return new Score(priority, groupId, resourcePriority, waitingScore, implScore);
    }

    public String toString() {
        return "ConstraintsFifo@" + this.getName();
    }
}

