/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.conn.mesos;

import es.bsc.conn.Connector;
import es.bsc.conn.clients.mesos.framework.MesosFramework;
import es.bsc.conn.clients.mesos.framework.exceptions.FrameworkException;
import es.bsc.conn.exceptions.ConnException;
import es.bsc.conn.types.HardwareDescription;
import es.bsc.conn.types.SoftwareDescription;
import es.bsc.conn.types.StarterCommand;
import es.bsc.conn.types.VirtualResource;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.mesos.Protos;

public class Mesos
extends Connector {
    private static final String PROP_CPUS = "cpus";
    private static final String PROP_MEM = "mem";
    private static final String PROP_DISK = "disk";
    private static final String PROP_PORTS = "ports";
    private static final String PROP_PRICE = "price";
    private static final double GIGAS_TO_MEGAS = 1024.0;
    private static final String UNDEFINED_IP = "-1.-1.-1.-1";
    private static final long SSH_PORT = 22L;
    private static final Logger logger = LogManager.getLogger("es.bsc.compss.Connectors.Conn.Mesos");
    private final MesosFramework framework;
    private final Map<String, VirtualResource> resources;

    public Mesos(Map<String, String> props) throws ConnException {
        super(props);
        logger.info("Initializing MESOS Connector");
        this.resources = new HashMap<String, VirtualResource>();
        try {
            this.framework = new MesosFramework(props);
        }
        catch (FrameworkException fe) {
            throw new ConnException(fe);
        }
    }

    @Override
    public Object create(String requestName, HardwareDescription hd, SoftwareDescription sd, Map<String, String> prop, StarterCommand starterCMD) throws ConnException {
        long adaptorMinPort = Long.parseLong(this.getProperty(hd.getImageProperties(), "adaptor-min-port", Integer.toString(-1)));
        long adaptorMaxPort = Long.parseLong(this.getProperty(hd.getImageProperties(), "adaptor-max-port", Integer.toString(-1)));
        LinkedList<Protos.Resource> res = new LinkedList<Protos.Resource>();
        Protos.Value.Ranges ports = this.buildRanges(adaptorMinPort, adaptorMaxPort);
        res.add(this.buildResource(PROP_CPUS, hd.getTotalCPUComputingUnits()));
        res.add(this.buildResource(PROP_MEM, 1024.0 * (double)hd.getMemorySize()));
        res.add(this.buildResource(PROP_DISK, 1024.0 * (double)hd.getStorageSize()));
        res.add(this.buildResource(PROP_PORTS, ports));
        String newId = this.framework.requestWorker(this.appName, hd.getImageName(), res);
        this.resources.put(newId, new VirtualResource(newId, hd, sd, prop));
        return newId;
    }

    @Override
    public Object[] createMultiple(int replicas, String requestName, HardwareDescription hd, SoftwareDescription sd, Map<String, String> prop, StarterCommand starterCMD) throws ConnException {
        Object[] envIds = new String[replicas];
        for (int i = 0; i < replicas; ++i) {
            envIds[i] = (String)this.create(requestName, hd, sd, prop, starterCMD);
        }
        return envIds;
    }

    @Override
    public VirtualResource waitUntilCreation(Object id) throws ConnException {
        String identifier = (String)id;
        if (!this.resources.containsKey(identifier)) {
            throw new ConnException("This identifier does not exist " + identifier);
        }
        VirtualResource vr = this.resources.get(identifier);
        String ip = this.framework.waitWorkerUntilRunning(identifier);
        if (UNDEFINED_IP.equals(ip)) {
            throw new ConnException("Could not wait until creation of worker " + id);
        }
        vr.setIp(ip);
        return vr;
    }

    @Override
    public float getPriceSlot(VirtualResource vr) {
        if (vr.getProperties().containsKey(PROP_PRICE)) {
            return Float.parseFloat(vr.getProperties().get(PROP_PRICE));
        }
        return 0.0f;
    }

    @Override
    public void destroy(Object id) {
        String identifier = (String)id;
        this.resources.remove(identifier);
        this.framework.removeWorker(identifier);
    }

    @Override
    public void close() {
        this.framework.stop();
    }

    private String getProperty(Map<String, String> props, String property, String defaultValue) {
        String value = props.get(property);
        return value != null && !value.isEmpty() ? value : defaultValue;
    }

    private Protos.Value.Range buildRange(long begin, long end) {
        return Protos.Value.Range.newBuilder().setBegin(begin).setEnd(end).build();
    }

    private Protos.Value.Scalar buildScalar(double value) {
        return Protos.Value.Scalar.newBuilder().setValue(value).build();
    }

    private Protos.Value.Ranges buildRanges(long begin, long end) {
        Protos.Value.Ranges.Builder ranges = Protos.Value.Ranges.newBuilder().addRange(this.buildRange(22L, 22L));
        if (begin > 0L && end > 0L) {
            ranges.addRange(this.buildRange(begin, end));
        }
        return ranges.build();
    }

    private Protos.Resource buildResource(String name, Protos.Value.Ranges ranges) {
        return Protos.Resource.newBuilder().setName(name).setType(Protos.Value.Type.RANGES).setRanges(ranges).build();
    }

    private Protos.Resource buildResource(String name, double value) {
        return Protos.Resource.newBuilder().setName(name).setType(Protos.Value.Type.SCALAR).setScalar(this.buildScalar(value)).build();
    }
}

