/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio.utils;

import es.bsc.comm.stage.Transfer;
import es.bsc.compss.nio.NIOAgent;
import java.util.concurrent.Semaphore;

public class NIOBindingObjectTransferListener {
    private int operation = 0;
    private int errors = 0;
    private boolean enabled = false;
    private final Semaphore sem;
    private NIOAgent agent;
    private Transfer transfer;

    public NIOBindingObjectTransferListener(NIOAgent agent, Semaphore sem) {
        this.agent = agent;
        this.sem = sem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enable() {
        boolean failed;
        boolean finished;
        NIOBindingObjectTransferListener nIOBindingObjectTransferListener = this;
        synchronized (nIOBindingObjectTransferListener) {
            this.enabled = true;
            finished = this.operation == 0;
            failed = this.errors > 0;
        }
        if (finished) {
            if (failed) {
                this.doFailures();
            } else {
                this.doReady();
            }
        }
    }

    public synchronized void addOperation() {
        ++this.operation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyEnd() {
        boolean enabled;
        boolean failed;
        boolean finished;
        NIOBindingObjectTransferListener nIOBindingObjectTransferListener = this;
        synchronized (nIOBindingObjectTransferListener) {
            --this.operation;
            finished = this.operation == 0;
            failed = this.errors > 0;
            enabled = this.enabled;
        }
        if (finished && enabled) {
            if (failed) {
                this.doFailures();
            } else {
                this.doReady();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyFailure(Exception e) {
        boolean enabled;
        boolean finished;
        NIOBindingObjectTransferListener nIOBindingObjectTransferListener = this;
        synchronized (nIOBindingObjectTransferListener) {
            ++this.errors;
            --this.operation;
            finished = this.operation == 0;
            enabled = this.enabled;
        }
        if (enabled && finished) {
            this.doFailures();
        }
    }

    private void doReady() {
        this.sem.release();
    }

    private void doFailures() {
        this.sem.release();
    }

    public void aquire() {
        try {
            this.sem.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public Transfer getTransfer() {
        return this.transfer;
    }

    public void setTransfer(Transfer t) {
        this.transfer = t;
    }

    public NIOAgent getAgent() {
        return this.agent;
    }
}

