/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.util.serializers;

import es.bsc.compss.types.exceptions.NonInstantiableException;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class XMLSerializer {
    private XMLSerializer() {
        throw new NonInstantiableException("Serializer");
    }

    public static void serialize(Object o, String file) throws IOException {
        FileOutputStream fout = new FileOutputStream(file);
        XMLEncoder e = new XMLEncoder(new BufferedOutputStream(fout));
        e.writeObject(o);
        e.close();
    }

    public static byte[] serialize(Object o) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XMLEncoder e = new XMLEncoder(new BufferedOutputStream(baos));
        e.writeObject(o);
        e.close();
        return baos.toByteArray();
    }

    public static Object deserialize(String file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        XMLDecoder d = new XMLDecoder(new BufferedInputStream(fis));
        Object o = d.readObject();
        d.close();
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object deserialize(byte[] data) {
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        XMLDecoder d = null;
        try {
            d = new XMLDecoder(new BufferedInputStream(bis));
            Object object = d.readObject();
            return object;
        }
        finally {
            if (d != null) {
                d.close();
            }
            try {
                bis.close();
            }
            catch (IOException iOException) {}
        }
    }
}

