/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.tracing.paraver;

import es.bsc.compss.types.tracing.ApplicationComposition;
import es.bsc.compss.types.tracing.EventsDefinition;
import es.bsc.compss.types.tracing.InfrastructureElement;
import es.bsc.compss.types.tracing.MalformedException;
import es.bsc.compss.types.tracing.SynchEvent;
import es.bsc.compss.types.tracing.Trace;
import es.bsc.compss.types.tracing.paraver.PRVHeader;
import es.bsc.compss.types.tracing.paraver.PRVLine;
import es.bsc.compss.types.tracing.paraver.PcfFile;
import es.bsc.compss.types.tracing.paraver.RowFile;
import es.bsc.compss.util.tracing.TraceTransformation;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PRVTrace
implements Trace {
    protected static final Logger LOGGER = LogManager.getLogger((String)"es.bsc.compss.Components.Tracing");
    protected static final boolean DEBUG = LOGGER.isDebugEnabled();
    private final String directory;
    private final String name;
    private final String path;
    private final String date;
    private final String duration;
    private final ApplicationComposition threadOrganization;
    private final ArrayList<InfrastructureElement> infrastructure;
    private final EventsDefinition definitions;

    public PRVTrace(String directory, String name) {
        String dirPath = new File(directory).getAbsolutePath();
        this.directory = dirPath = dirPath + (dirPath.endsWith(File.separator) ? "" : File.separator);
        this.name = name;
        this.path = dirPath + name;
        this.definitions = new PcfFile(this.path + ".pcf");
        PRVHeader header = this.getHeader();
        this.date = header.getDate();
        this.duration = header.getDuration();
        this.infrastructure = header.getInfrastructure();
        this.threadOrganization = header.getThreadOrganization();
        try {
            RowFile.updateStructuresWithRowContent(this.getRowFilePath(), this.infrastructure, this.threadOrganization);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public PRVTrace(File trace) {
        this(PRVTrace.parseDirectory(trace), PRVTrace.parseTraceName(trace));
    }

    private static String parseTraceName(File trace) {
        String fileName = trace.getName();
        if (fileName.endsWith(".prv") || fileName.endsWith(".pcf") || fileName.endsWith(".row")) {
            return fileName.substring(0, fileName.length() - 4);
        }
        return fileName;
    }

    private static String parseDirectory(File trace) {
        String dirPath = trace.getParent();
        return dirPath + (dirPath.endsWith(File.separator) ? "" : File.separator);
    }

    private PRVTrace(String directory, String name, String date, String duration, ArrayList<InfrastructureElement> infrastructure, ApplicationComposition threads, EventsDefinition definitions) {
        this.directory = directory + (directory.endsWith(File.separator) ? "" : File.separator);
        this.name = name;
        this.path = this.directory + name;
        this.date = date;
        this.duration = duration;
        this.infrastructure = infrastructure;
        this.threadOrganization = threads;
        this.definitions = definitions;
    }

    public static PRVTrace generateNew(String directory, String name, String date, String duration, ArrayList<InfrastructureElement> infrastructure, ApplicationComposition threads, EventsDefinition definitions) throws IOException {
        PRVTrace trace = new PRVTrace(directory, name, date, duration, infrastructure, threads, definitions);
        String prvPath = trace.getPrvFilePath();
        File prvFile = new File(prvPath);
        boolean fileCreated = prvFile.createNewFile();
        if (!fileCreated) {
            throw new IOException("ERROR: File " + prvFile.getAbsolutePath() + " already existed");
        }
        String header = PRVHeader.generateTraceHeader(date, duration, infrastructure, threads);
        try (PrintWriter writer = new PrintWriter(new FileWriter(prvFile, false));){
            writer.println(header);
        }
        RowFile.generateRowFile(infrastructure, threads, trace.getRowFilePath());
        PcfFile.generatePCFFile(definitions, trace.getPcfFilePath());
        return trace;
    }

    @Override
    public String getDirectory() {
        return this.directory;
    }

    @Override
    public String getName() {
        return this.name;
    }

    private PRVHeader getHeader() {
        try {
            BufferedReader br = new BufferedReader(new FileReader(this.getPrvFilePath()));
            String header = br.readLine();
            if (header != null) {
                return new PRVHeader(header);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public String getDate() {
        return this.date;
    }

    @Override
    public String getDuration() {
        return this.duration;
    }

    @Override
    public long getDurationInNS() {
        long scale;
        String[] parts = this.duration.split("_");
        long value = Long.parseLong(parts[0]);
        switch (parts[1]) {
            case "ns": {
                scale = 1L;
                break;
            }
            case "us": {
                scale = 1000L;
                break;
            }
            case "ms": {
                scale = 1000000L;
                break;
            }
            default: {
                scale = 1L;
            }
        }
        return value * scale;
    }

    private String getPrvFilePath() {
        return this.path + ".prv";
    }

    private String getRowFilePath() {
        return this.path + ".row";
    }

    private String getPcfFilePath() {
        return this.path + ".pcf";
    }

    @Override
    public ArrayList<InfrastructureElement> getInfrastructure() {
        return this.infrastructure;
    }

    @Override
    public ApplicationComposition getThreadOrganization() {
        return this.threadOrganization;
    }

    @Override
    public EventsDefinition getEventsDefinition() {
        return this.definitions;
    }

    @Override
    public Map<Integer, List<SynchEvent>> getSyncEvents(Integer workerID) throws IOException {
        String prvFile = this.getPrvFilePath();
        if (DEBUG) {
            LOGGER.debug("Getting sync events from: " + prvFile + " for worker " + workerID);
        }
        HashMap<Integer, List<SynchEvent>> idToSyncInfo = new HashMap<Integer, List<SynchEvent>>();
        try (FileInputStream inputStream = new FileInputStream(prvFile);
             Scanner sc = new Scanner((InputStream)inputStream, "UTF-8");){
            while (sc.hasNextLine()) {
                String line = sc.nextLine();
                SynchEvent event = PRVLine.parseSynchEvent(line);
                if (event == null) continue;
                Integer wID = workerID == -1 ? Integer.parseInt(event.getWorkerId()) : workerID;
                ArrayList<SynchEvent> currentValue = (ArrayList<SynchEvent>)idToSyncInfo.get(wID);
                if (currentValue == null) {
                    currentValue = new ArrayList<SynchEvent>();
                    idToSyncInfo.put(wID, currentValue);
                }
                currentValue.add(event);
            }
            if (sc.ioException() != null) {
                throw sc.ioException();
            }
        }
        return idToSyncInfo;
    }

    @Override
    public Trace.RecordScanner getRecords() throws FileNotFoundException {
        return new PRVRecordScanner(this.getPrvFilePath());
    }

    @Override
    public Trace.RecordAppender getRecordAppender() throws IOException {
        return new PRVRecordAppender(this.getPrvFilePath());
    }

    public void applyTransformations(TraceTransformation ... transformations) throws FileNotFoundException, MalformedException, IOException {
        for (TraceTransformation transformation : transformations) {
            transformation.apply(this.definitions);
            transformation.apply(this.infrastructure, this.threadOrganization);
        }
        String originalPrvPath = this.getPrvFilePath();
        String tmpPrvPath = originalPrvPath + ".tmp";
        File tmpPrv = new File(tmpPrvPath);
        boolean fileCreated = tmpPrv.createNewFile();
        if (!fileCreated) {
            throw new IOException("ERROR: File " + tmpPrv.getAbsolutePath() + " already existed");
        }
        String header = PRVHeader.generateTraceHeader(this.date, this.duration, this.infrastructure, this.threadOrganization);
        try (PrintWriter writer = new PrintWriter(new FileWriter(tmpPrv, false));){
            writer.println(header);
            RowFile.generateRowFile(this.infrastructure, this.threadOrganization, this.getRowFilePath());
            PcfFile.generatePCFFile(this.definitions, this.getPcfFilePath());
            try (Trace.RecordScanner records = this.getRecords();){
                String record;
                while ((record = records.next()) != null && !record.isEmpty()) {
                    PRVLine prvLine = PRVLine.parse(record);
                    for (TraceTransformation transformation : transformations) {
                        transformation.apply(prvLine);
                    }
                    writer.println(prvLine.toString());
                }
            }
        }
        tmpPrv.renameTo(new File(originalPrvPath));
    }

    public boolean exists() {
        return new File(this.getPrvFilePath()).exists() && new File(this.getPcfFilePath()).exists() && new File(this.getRowFilePath()).exists();
    }

    public void renameAs(String directory, String name) {
        String dirPath = new File(directory).getAbsolutePath();
        dirPath = dirPath + (dirPath.endsWith(File.separator) ? "" : File.separator);
        String path = dirPath + name;
        PRVTrace.renameFile(this.getPrvFilePath(), path + ".prv");
        PRVTrace.renameFile(this.getPcfFilePath(), path + ".pcf");
        PRVTrace.renameFile(this.getRowFilePath(), path + ".row");
    }

    private static void renameFile(String original, String target) {
        File originalF;
        File targetF = new File(target);
        if (targetF.exists()) {
            targetF.delete();
        }
        if ((originalF = new File(original)).exists()) {
            originalF.renameTo(targetF);
        }
    }

    public static class PRVRecordAppender
    implements Trace.RecordAppender {
        private final PrintWriter pw;

        private PRVRecordAppender(String path) throws IOException {
            this.pw = new PrintWriter(new FileWriter(path, true));
        }

        @Override
        public void append(String event) throws IOException {
            this.pw.println(event);
        }

        @Override
        public void close() throws IOException {
            this.pw.close();
        }
    }

    public static class PRVRecordScanner
    implements Trace.RecordScanner {
        private final BufferedReader br;

        private PRVRecordScanner(String prv) throws FileNotFoundException {
            this.br = new BufferedReader(new FileReader(prv));
            try {
                this.br.readLine();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public String next() throws IOException {
            return this.br.readLine();
        }

        @Override
        public void close() throws IOException {
            this.br.close();
        }
    }
}

