/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.util.tracing;

import es.bsc.compss.types.tracing.EventsDefinition;
import es.bsc.compss.types.tracing.MalformedException;
import es.bsc.compss.types.tracing.Trace;
import es.bsc.compss.types.tracing.paraver.PRVLine;
import es.bsc.compss.util.tracing.TraceTransformation;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class TraceMerger {
    protected static final Logger LOGGER = LogManager.getLogger((String)"es.bsc.compss.Components.Tracing");
    protected static final boolean DEBUG = LOGGER.isDebugEnabled();
    protected final Trace[] inputTraces;

    public TraceMerger(Trace[] inputTraces) throws FileNotFoundException, IOException {
        if (inputTraces == null || inputTraces.length == 0) {
            throw new FileNotFoundException("No traces to merge found.");
        }
        this.inputTraces = inputTraces;
    }

    public Map<String, String> getUnifiedCoreElementDefinition() throws IOException, MalformedException {
        HashMap<String, String> globalCE = new HashMap<String, String>();
        globalCE.put("End", "0");
        int maxCEValue = 1;
        for (Trace workerTrace : this.inputTraces) {
            EventsDefinition traceEvents = workerTrace.getEventsDefinition();
            Map<String, String> traceCEs = traceEvents.getCEsMapping();
            for (Map.Entry<String, String> ce : traceCEs.entrySet()) {
                String value = ce.getValue();
                if (globalCE.containsKey(value)) continue;
                globalCE.put(value, Integer.toString(maxCEValue));
                LOGGER.debug("Added " + value + " to global CE index with id: " + maxCEValue);
                ++maxCEValue;
            }
        }
        return globalCE;
    }

    protected Collection<String> getAllHWCounters() throws IOException, MalformedException {
        HashSet<String> allHWCounters = new HashSet<String>();
        for (Trace trace : this.inputTraces) {
            EventsDefinition traceEvents = trace.getEventsDefinition();
            allHWCounters.addAll(traceEvents.getHWCounters());
        }
        return allHWCounters;
    }

    protected static void mergeEvents(Trace[] inputTraces, TraceTransformation[][] transformations, Trace output) throws Exception {
        try (Trace.RecordAppender eventAppedner = output.getRecordAppender();){
            int numTraces = inputTraces.length;
            int fullyRead = 0;
            Trace.RecordScanner[] records = new Trace.RecordScanner[numTraces];
            String[] topRecords = new String[records.length];
            for (int traceIdx = 0; traceIdx < numTraces; ++traceIdx) {
                records[traceIdx] = inputTraces[traceIdx].getRecords();
                topRecords[traceIdx] = records[traceIdx].next();
                if (topRecords[traceIdx] == null) {
                    ++fullyRead;
                    records[traceIdx].close();
                    continue;
                }
                PRVLine prvLine = PRVLine.parse(topRecords[traceIdx]);
                for (TraceTransformation transformation : transformations[traceIdx]) {
                    transformation.apply(prvLine);
                }
                topRecords[traceIdx] = prvLine.toString();
            }
            LOGGER.debug("Populating trace content");
            while (fullyRead < numTraces) {
                int earliestLinePos = 0;
                for (int traceIdx = 0; traceIdx < topRecords.length; ++traceIdx) {
                    PRVLine prvLine;
                    if (topRecords[traceIdx] == null || topRecords[traceIdx].isEmpty() || !(prvLine = PRVLine.parse(topRecords[traceIdx])).goesBefore(topRecords[earliestLinePos])) continue;
                    earliestLinePos = traceIdx;
                }
                String toWrite = topRecords[earliestLinePos];
                eventAppedner.append(toWrite);
                String newLine = records[earliestLinePos].next();
                if (newLine != null) {
                    PRVLine prvLine = PRVLine.parse(newLine);
                    for (TraceTransformation transformation : transformations[earliestLinePos]) {
                        transformation.apply(prvLine);
                    }
                    newLine = prvLine.toString();
                } else {
                    ++fullyRead;
                    records[earliestLinePos].close();
                }
                topRecords[earliestLinePos] = newLine;
            }
        }
    }

    protected static void removeFolder(String sandBox) throws IOException {
        File wdirFile = new File(sandBox);
        TraceMerger.remove(wdirFile);
    }

    private static void remove(File f) throws IOException {
        if (f.exists()) {
            if (f.isDirectory()) {
                for (File child : f.listFiles()) {
                    TraceMerger.remove(child);
                }
            }
            Files.delete(f.toPath());
        }
    }
}

