/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.consumer.CommitFailedException;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.clients.consumer.RetriableCommitFailedException;
import org.apache.kafka.clients.consumer.internals.AbstractCoordinator;
import org.apache.kafka.clients.consumer.internals.ConsumerInterceptors;
import org.apache.kafka.clients.consumer.internals.ConsumerMetadata;
import org.apache.kafka.clients.consumer.internals.ConsumerNetworkClient;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.clients.consumer.internals.Heartbeat;
import org.apache.kafka.clients.consumer.internals.PartitionAssignor;
import org.apache.kafka.clients.consumer.internals.RequestFuture;
import org.apache.kafka.clients.consumer.internals.RequestFutureListener;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.FencedInstanceIdException;
import org.apache.kafka.common.errors.GroupAuthorizationException;
import org.apache.kafka.common.errors.InterruptException;
import org.apache.kafka.common.errors.RetriableException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.message.JoinGroupRequestData;
import org.apache.kafka.common.message.JoinGroupResponseData;
import org.apache.kafka.common.message.OffsetCommitRequestData;
import org.apache.kafka.common.message.OffsetCommitResponseData;
import org.apache.kafka.common.metrics.Measurable;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.OffsetCommitRequest;
import org.apache.kafka.common.requests.OffsetCommitResponse;
import org.apache.kafka.common.requests.OffsetFetchRequest;
import org.apache.kafka.common.requests.OffsetFetchResponse;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Timer;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;

public final class ConsumerCoordinator
extends AbstractCoordinator {
    private final Logger log;
    private final List<PartitionAssignor> assignors;
    private final ConsumerMetadata metadata;
    private final ConsumerCoordinatorMetrics sensors;
    private final SubscriptionState subscriptions;
    private final OffsetCommitCallback defaultOffsetCommitCallback;
    private final boolean autoCommitEnabled;
    private final int autoCommitIntervalMs;
    private final ConsumerInterceptors<?, ?> interceptors;
    private final AtomicInteger pendingAsyncCommits;
    private final ConcurrentLinkedQueue<OffsetCommitCompletion> completedOffsetCommits;
    private boolean isLeader = false;
    private Set<String> joinedSubscription;
    private MetadataSnapshot metadataSnapshot;
    private MetadataSnapshot assignmentSnapshot;
    private Timer nextAutoCommitTimer;
    private AtomicBoolean asyncCommitFenced;
    private PendingCommittedOffsetRequest pendingCommittedOffsetRequest = null;

    public ConsumerCoordinator(LogContext logContext, ConsumerNetworkClient client, String groupId, Optional<String> groupInstanceId, int rebalanceTimeoutMs, int sessionTimeoutMs, Heartbeat heartbeat, List<PartitionAssignor> assignors, ConsumerMetadata metadata, SubscriptionState subscriptions, Metrics metrics, String metricGrpPrefix, Time time, long retryBackoffMs, boolean autoCommitEnabled, int autoCommitIntervalMs, ConsumerInterceptors<?, ?> interceptors, boolean leaveGroupOnClose) {
        super(logContext, client, groupId, groupInstanceId, rebalanceTimeoutMs, sessionTimeoutMs, heartbeat, metrics, metricGrpPrefix, time, retryBackoffMs, leaveGroupOnClose);
        this.log = logContext.logger(ConsumerCoordinator.class);
        this.metadata = metadata;
        this.metadataSnapshot = new MetadataSnapshot(subscriptions, metadata.fetch(), metadata.updateVersion());
        this.subscriptions = subscriptions;
        this.defaultOffsetCommitCallback = new DefaultOffsetCommitCallback();
        this.autoCommitEnabled = autoCommitEnabled;
        this.autoCommitIntervalMs = autoCommitIntervalMs;
        this.assignors = assignors;
        this.completedOffsetCommits = new ConcurrentLinkedQueue();
        this.sensors = new ConsumerCoordinatorMetrics(metrics, metricGrpPrefix);
        this.interceptors = interceptors;
        this.pendingAsyncCommits = new AtomicInteger();
        this.asyncCommitFenced = new AtomicBoolean(false);
        if (autoCommitEnabled) {
            this.nextAutoCommitTimer = time.timer(autoCommitIntervalMs);
        }
        this.metadata.requestUpdate();
    }

    @Override
    public String protocolType() {
        return "consumer";
    }

    @Override
    protected JoinGroupRequestData.JoinGroupRequestProtocolCollection metadata() {
        this.log.debug("Joining group with current subscription: {}", this.subscriptions.subscription());
        this.joinedSubscription = this.subscriptions.subscription();
        JoinGroupRequestData.JoinGroupRequestProtocolCollection protocolSet = new JoinGroupRequestData.JoinGroupRequestProtocolCollection();
        for (PartitionAssignor assignor : this.assignors) {
            PartitionAssignor.Subscription subscription = assignor.subscription(this.joinedSubscription);
            ByteBuffer metadata = ConsumerProtocol.serializeSubscription(subscription);
            protocolSet.add(new JoinGroupRequestData.JoinGroupRequestProtocol().setName(assignor.name()).setMetadata(Utils.toArray(metadata)));
        }
        return protocolSet;
    }

    public void updatePatternSubscription(Cluster cluster) {
        Set<String> topicsToSubscribe = cluster.topics().stream().filter(this.subscriptions::matchesSubscribedPattern).collect(Collectors.toSet());
        if (this.subscriptions.subscribeFromPattern(topicsToSubscribe)) {
            this.metadata.requestUpdateForNewTopics();
        }
    }

    private PartitionAssignor lookupAssignor(String name) {
        for (PartitionAssignor assignor : this.assignors) {
            if (!assignor.name().equals(name)) continue;
            return assignor;
        }
        return null;
    }

    private void handleAssignmentMismatch(PartitionAssignor.Assignment assignment) {
        Set invalidAssignments = assignment.partitions().stream().filter(topicPartition -> !this.joinedSubscription.contains(topicPartition.topic())).collect(Collectors.toSet());
        if (invalidAssignments.size() > 0) {
            throw new IllegalStateException("Consumer was assigned partitions " + invalidAssignments + " which didn't correspond to subscription request " + this.joinedSubscription);
        }
        this.requestRejoin();
    }

    private void maybeUpdateJoinedSubscription(Set<TopicPartition> assignedPartitions) {
        HashSet<String> addedTopics = new HashSet<String>();
        for (TopicPartition tp : assignedPartitions) {
            if (this.joinedSubscription.contains(tp.topic())) continue;
            addedTopics.add(tp.topic());
        }
        if (!addedTopics.isEmpty()) {
            HashSet<String> newSubscription = new HashSet<String>(this.subscriptions.subscription());
            HashSet<String> newJoinedSubscription = new HashSet<String>(this.joinedSubscription);
            newSubscription.addAll(addedTopics);
            newJoinedSubscription.addAll(addedTopics);
            if (this.subscriptions.subscribeFromPattern(newSubscription)) {
                this.metadata.requestUpdateForNewTopics();
            }
            this.joinedSubscription = newJoinedSubscription;
        }
    }

    @Override
    protected void onJoinComplete(int generation, String memberId, String assignmentStrategy, ByteBuffer assignmentBuffer) {
        PartitionAssignor assignor;
        if (!this.isLeader) {
            this.assignmentSnapshot = null;
        }
        if ((assignor = this.lookupAssignor(assignmentStrategy)) == null) {
            throw new IllegalStateException("Coordinator selected invalid assignment protocol: " + assignmentStrategy);
        }
        PartitionAssignor.Assignment assignment = ConsumerProtocol.deserializeAssignment(assignmentBuffer);
        if (!this.subscriptions.assignFromSubscribed(assignment.partitions())) {
            this.handleAssignmentMismatch(assignment);
            return;
        }
        Set<TopicPartition> assignedPartitions = this.subscriptions.assignedPartitions();
        this.maybeUpdateJoinedSubscription(assignedPartitions);
        assignor.onAssignment(assignment, generation);
        if (this.autoCommitEnabled) {
            this.nextAutoCommitTimer.updateAndReset(this.autoCommitIntervalMs);
        }
        ConsumerRebalanceListener listener = this.subscriptions.rebalanceListener();
        this.log.info("Setting newly assigned partitions: {}", (Object)Utils.join(assignedPartitions, ", "));
        try {
            listener.onPartitionsAssigned(assignedPartitions);
        }
        catch (InterruptException | WakeupException e) {
            throw e;
        }
        catch (Exception e) {
            this.log.error("User provided listener {} failed on partition assignment", (Object)listener.getClass().getName(), (Object)e);
        }
    }

    void maybeUpdateSubscriptionMetadata() {
        int version = this.metadata.updateVersion();
        if (version > this.metadataSnapshot.version) {
            Cluster cluster = this.metadata.fetch();
            if (this.subscriptions.hasPatternSubscription()) {
                this.updatePatternSubscription(cluster);
            }
            this.metadataSnapshot = new MetadataSnapshot(this.subscriptions, cluster, version);
        }
    }

    public boolean poll(Timer timer) {
        this.maybeUpdateSubscriptionMetadata();
        this.invokeCompletedOffsetCommitCallbacks();
        if (this.subscriptions.partitionsAutoAssigned()) {
            this.pollHeartbeat(timer.currentTimeMs());
            if (this.coordinatorUnknown() && !this.ensureCoordinatorReady(timer)) {
                return false;
            }
            if (this.rejoinNeededOrPending()) {
                if (this.subscriptions.hasPatternSubscription()) {
                    if (this.metadata.timeToAllowUpdate(timer.currentTimeMs()) == 0L) {
                        this.metadata.requestUpdate();
                    }
                    if (!this.client.ensureFreshMetadata(timer)) {
                        return false;
                    }
                    this.maybeUpdateSubscriptionMetadata();
                }
                if (!this.ensureActiveGroup(timer)) {
                    return false;
                }
            }
        } else if (this.metadata.updateRequested() && !this.client.hasReadyNodes(timer.currentTimeMs())) {
            this.client.awaitMetadataUpdate(timer);
        }
        this.maybeAutoCommitOffsetsAsync(timer.currentTimeMs());
        return true;
    }

    public long timeToNextPoll(long now) {
        if (!this.autoCommitEnabled) {
            return this.timeToNextHeartbeat(now);
        }
        return Math.min(this.nextAutoCommitTimer.remainingMs(), this.timeToNextHeartbeat(now));
    }

    private void updateGroupSubscription(Set<String> topics) {
        if (this.subscriptions.groupSubscribe(topics)) {
            this.metadata.requestUpdateForNewTopics();
        }
        if (!this.client.ensureFreshMetadata(this.time.timer(Long.MAX_VALUE))) {
            throw new TimeoutException();
        }
        this.maybeUpdateSubscriptionMetadata();
    }

    @Override
    protected Map<String, ByteBuffer> performAssignment(String leaderId, String assignmentStrategy, List<JoinGroupResponseData.JoinGroupResponseMember> allSubscriptions) {
        PartitionAssignor assignor = this.lookupAssignor(assignmentStrategy);
        if (assignor == null) {
            throw new IllegalStateException("Coordinator selected invalid assignment protocol: " + assignmentStrategy);
        }
        HashSet<String> allSubscribedTopics = new HashSet<String>();
        HashMap<String, PartitionAssignor.Subscription> subscriptions = new HashMap<String, PartitionAssignor.Subscription>();
        for (JoinGroupResponseData.JoinGroupResponseMember memberSubScription : allSubscriptions) {
            PartitionAssignor.Subscription subscription = ConsumerProtocol.deserializeSubscription(ByteBuffer.wrap(memberSubScription.metadata()));
            subscriptions.put(memberSubScription.memberId(), subscription);
            allSubscribedTopics.addAll(subscription.topics());
        }
        this.updateGroupSubscription(allSubscribedTopics);
        this.isLeader = true;
        this.log.debug("Performing assignment using strategy {} with subscriptions {}", (Object)assignor.name(), subscriptions);
        Map<String, PartitionAssignor.Assignment> assignment = assignor.assign(this.metadata.fetch(), subscriptions);
        HashSet<String> assignedTopics = new HashSet<String>();
        for (PartitionAssignor.Assignment assigned : assignment.values()) {
            for (TopicPartition tp : assigned.partitions()) {
                assignedTopics.add(tp.topic());
            }
        }
        if (!assignedTopics.containsAll(allSubscribedTopics)) {
            HashSet<String> notAssignedTopics = new HashSet<String>(allSubscribedTopics);
            notAssignedTopics.removeAll(assignedTopics);
            this.log.warn("The following subscribed topics are not assigned to any members: {} ", notAssignedTopics);
        }
        if (!allSubscribedTopics.containsAll(assignedTopics)) {
            HashSet newlyAddedTopics = new HashSet(assignedTopics);
            newlyAddedTopics.removeAll(allSubscribedTopics);
            this.log.info("The following not-subscribed topics are assigned, and their metadata will be fetched from the brokers: {}", newlyAddedTopics);
            allSubscribedTopics.addAll(assignedTopics);
            this.updateGroupSubscription(allSubscribedTopics);
        }
        this.assignmentSnapshot = this.metadataSnapshot;
        this.log.debug("Finished assignment for group: {}", assignment);
        HashMap<String, ByteBuffer> groupAssignment = new HashMap<String, ByteBuffer>();
        for (Map.Entry<String, PartitionAssignor.Assignment> assignmentEntry : assignment.entrySet()) {
            ByteBuffer buffer = ConsumerProtocol.serializeAssignment(assignmentEntry.getValue());
            groupAssignment.put(assignmentEntry.getKey(), buffer);
        }
        return groupAssignment;
    }

    @Override
    protected void onJoinPrepare(int generation, String memberId) {
        this.maybeAutoCommitOffsetsSync(this.time.timer(this.rebalanceTimeoutMs));
        ConsumerRebalanceListener listener = this.subscriptions.rebalanceListener();
        Set<TopicPartition> revoked = this.subscriptions.assignedPartitions();
        this.log.info("Revoking previously assigned partitions {}", revoked);
        try {
            listener.onPartitionsRevoked(revoked);
        }
        catch (InterruptException | WakeupException e) {
            throw e;
        }
        catch (Exception e) {
            this.log.error("User provided listener {} failed on partition revocation", (Object)listener.getClass().getName(), (Object)e);
        }
        this.isLeader = false;
        this.subscriptions.resetGroupSubscription();
    }

    @Override
    public boolean rejoinNeededOrPending() {
        if (!this.subscriptions.partitionsAutoAssigned()) {
            return false;
        }
        if (this.assignmentSnapshot != null && !this.assignmentSnapshot.matches(this.metadataSnapshot)) {
            return true;
        }
        if (this.joinedSubscription != null && !this.joinedSubscription.equals(this.subscriptions.subscription())) {
            return true;
        }
        return super.rejoinNeededOrPending();
    }

    public boolean refreshCommittedOffsetsIfNeeded(Timer timer) {
        Set<TopicPartition> missingFetchPositions = this.subscriptions.missingFetchPositions();
        Map<TopicPartition, OffsetAndMetadata> offsets = this.fetchCommittedOffsets(missingFetchPositions, timer);
        if (offsets == null) {
            return false;
        }
        for (Map.Entry<TopicPartition, OffsetAndMetadata> entry : offsets.entrySet()) {
            TopicPartition tp = entry.getKey();
            OffsetAndMetadata offsetAndMetadata = entry.getValue();
            Metadata.LeaderAndEpoch leaderAndEpoch = this.metadata.leaderAndEpoch(tp);
            SubscriptionState.FetchPosition position = new SubscriptionState.FetchPosition(offsetAndMetadata.offset(), offsetAndMetadata.leaderEpoch(), leaderAndEpoch);
            this.log.info("Setting offset for partition {} to the committed offset {}", (Object)tp, (Object)position);
            entry.getValue().leaderEpoch().ifPresent(epoch -> this.metadata.updateLastSeenEpochIfNewer((TopicPartition)entry.getKey(), (int)epoch));
            this.subscriptions.seekUnvalidated(tp, position);
        }
        return true;
    }

    public Map<TopicPartition, OffsetAndMetadata> fetchCommittedOffsets(Set<TopicPartition> partitions, Timer timer) {
        if (partitions.isEmpty()) {
            return Collections.emptyMap();
        }
        AbstractCoordinator.Generation generation = this.generation();
        if (this.pendingCommittedOffsetRequest != null && !this.pendingCommittedOffsetRequest.sameRequest(partitions, generation)) {
            this.pendingCommittedOffsetRequest = null;
        }
        do {
            RequestFuture<Map<TopicPartition, OffsetAndMetadata>> future;
            if (!this.ensureCoordinatorReady(timer)) {
                return null;
            }
            if (this.pendingCommittedOffsetRequest != null) {
                future = this.pendingCommittedOffsetRequest.response;
            } else {
                future = this.sendOffsetFetchRequest(partitions);
                this.pendingCommittedOffsetRequest = new PendingCommittedOffsetRequest(partitions, generation, future);
            }
            this.client.poll(future, timer);
            if (future.isDone()) {
                this.pendingCommittedOffsetRequest = null;
                if (future.succeeded()) {
                    return future.value();
                }
                if (!future.isRetriable()) {
                    throw future.exception();
                }
            } else {
                return null;
            }
            timer.sleep(this.retryBackoffMs);
        } while (timer.notExpired());
        return null;
    }

    @Override
    public void close(Timer timer) {
        this.client.disableWakeups();
        try {
            this.maybeAutoCommitOffsetsSync(timer);
            while (this.pendingAsyncCommits.get() > 0 && timer.notExpired()) {
                this.ensureCoordinatorReady(timer);
                this.client.poll(timer);
                this.invokeCompletedOffsetCommitCallbacks();
            }
        }
        finally {
            super.close(timer);
        }
    }

    void invokeCompletedOffsetCommitCallbacks() {
        OffsetCommitCompletion completion;
        if (this.asyncCommitFenced.get()) {
            throw new FencedInstanceIdException("Get fenced exception for group.instance.id " + this.groupInstanceId.orElse("unset_instance_id"));
        }
        while ((completion = this.completedOffsetCommits.poll()) != null) {
            completion.invoke();
        }
    }

    public void commitOffsetsAsync(final Map<TopicPartition, OffsetAndMetadata> offsets, final OffsetCommitCallback callback) {
        this.invokeCompletedOffsetCommitCallbacks();
        if (!this.coordinatorUnknown()) {
            this.doCommitOffsetsAsync(offsets, callback);
        } else {
            this.pendingAsyncCommits.incrementAndGet();
            this.lookupCoordinator().addListener(new RequestFutureListener<Void>(){

                @Override
                public void onSuccess(Void value) {
                    ConsumerCoordinator.this.pendingAsyncCommits.decrementAndGet();
                    ConsumerCoordinator.this.doCommitOffsetsAsync(offsets, callback);
                    ConsumerCoordinator.this.client.pollNoWakeup();
                }

                @Override
                public void onFailure(RuntimeException e) {
                    ConsumerCoordinator.this.pendingAsyncCommits.decrementAndGet();
                    ConsumerCoordinator.this.completedOffsetCommits.add(new OffsetCommitCompletion(callback, offsets, new RetriableCommitFailedException(e)));
                }
            });
        }
        this.client.pollNoWakeup();
    }

    private void doCommitOffsetsAsync(final Map<TopicPartition, OffsetAndMetadata> offsets, OffsetCommitCallback callback) {
        RequestFuture<Void> future = this.sendOffsetCommitRequest(offsets);
        final OffsetCommitCallback cb = callback == null ? this.defaultOffsetCommitCallback : callback;
        future.addListener(new RequestFutureListener<Void>(){

            @Override
            public void onSuccess(Void value) {
                if (ConsumerCoordinator.this.interceptors != null) {
                    ConsumerCoordinator.this.interceptors.onCommit(offsets);
                }
                ConsumerCoordinator.this.completedOffsetCommits.add(new OffsetCommitCompletion(cb, offsets, null));
            }

            @Override
            public void onFailure(RuntimeException e) {
                RuntimeException commitException = e;
                if (e instanceof RetriableException) {
                    commitException = new RetriableCommitFailedException(e);
                }
                ConsumerCoordinator.this.completedOffsetCommits.add(new OffsetCommitCompletion(cb, offsets, commitException));
                if (commitException instanceof FencedInstanceIdException) {
                    ConsumerCoordinator.this.asyncCommitFenced.set(true);
                }
            }
        });
    }

    public boolean commitOffsetsSync(Map<TopicPartition, OffsetAndMetadata> offsets, Timer timer) {
        this.invokeCompletedOffsetCommitCallbacks();
        if (offsets.isEmpty()) {
            return true;
        }
        do {
            if (this.coordinatorUnknown() && !this.ensureCoordinatorReady(timer)) {
                return false;
            }
            RequestFuture<Void> future = this.sendOffsetCommitRequest(offsets);
            this.client.poll(future, timer);
            this.invokeCompletedOffsetCommitCallbacks();
            if (future.succeeded()) {
                if (this.interceptors != null) {
                    this.interceptors.onCommit(offsets);
                }
                return true;
            }
            if (future.failed() && !future.isRetriable()) {
                throw future.exception();
            }
            timer.sleep(this.retryBackoffMs);
        } while (timer.notExpired());
        return false;
    }

    public void maybeAutoCommitOffsetsAsync(long now) {
        if (this.autoCommitEnabled) {
            this.nextAutoCommitTimer.update(now);
            if (this.nextAutoCommitTimer.isExpired()) {
                this.nextAutoCommitTimer.reset(this.autoCommitIntervalMs);
                this.doAutoCommitOffsetsAsync();
            }
        }
    }

    private void doAutoCommitOffsetsAsync() {
        Map<TopicPartition, OffsetAndMetadata> allConsumedOffsets = this.subscriptions.allConsumed();
        this.log.debug("Sending asynchronous auto-commit of offsets {}", allConsumedOffsets);
        this.commitOffsetsAsync(allConsumedOffsets, new OffsetCommitCallback(){

            @Override
            public void onComplete(Map<TopicPartition, OffsetAndMetadata> offsets, Exception exception) {
                if (exception != null) {
                    if (exception instanceof RetriableException) {
                        ConsumerCoordinator.this.log.debug("Asynchronous auto-commit of offsets {} failed due to retriable error: {}", offsets, (Object)exception);
                        ConsumerCoordinator.this.nextAutoCommitTimer.updateAndReset(ConsumerCoordinator.this.retryBackoffMs);
                    } else {
                        ConsumerCoordinator.this.log.warn("Asynchronous auto-commit of offsets {} failed: {}", offsets, (Object)exception.getMessage());
                    }
                } else {
                    ConsumerCoordinator.this.log.debug("Completed asynchronous auto-commit of offsets {}", offsets);
                }
            }
        });
    }

    private void maybeAutoCommitOffsetsSync(Timer timer) {
        if (this.autoCommitEnabled) {
            Map<TopicPartition, OffsetAndMetadata> allConsumedOffsets = this.subscriptions.allConsumed();
            try {
                this.log.debug("Sending synchronous auto-commit of offsets {}", allConsumedOffsets);
                if (!this.commitOffsetsSync(allConsumedOffsets, timer)) {
                    this.log.debug("Auto-commit of offsets {} timed out before completion", allConsumedOffsets);
                }
            }
            catch (InterruptException | WakeupException e) {
                this.log.debug("Auto-commit of offsets {} was interrupted before completion", allConsumedOffsets);
                throw e;
            }
            catch (Exception e) {
                this.log.warn("Synchronous auto-commit of offsets {} failed: {}", allConsumedOffsets, (Object)e.getMessage());
            }
        }
    }

    private RequestFuture<Void> sendOffsetCommitRequest(Map<TopicPartition, OffsetAndMetadata> offsets) {
        AbstractCoordinator.Generation generation;
        if (offsets.isEmpty()) {
            return RequestFuture.voidSuccess();
        }
        Node coordinator = this.checkAndGetCoordinator();
        if (coordinator == null) {
            return RequestFuture.coordinatorNotAvailable();
        }
        HashMap<String, OffsetCommitRequestData.OffsetCommitRequestTopic> requestTopicDataMap = new HashMap<String, OffsetCommitRequestData.OffsetCommitRequestTopic>();
        for (Map.Entry<TopicPartition, OffsetAndMetadata> entry : offsets.entrySet()) {
            TopicPartition topicPartition = entry.getKey();
            OffsetAndMetadata offsetAndMetadata = entry.getValue();
            if (offsetAndMetadata.offset() < 0L) {
                return RequestFuture.failure(new IllegalArgumentException("Invalid offset: " + offsetAndMetadata.offset()));
            }
            OffsetCommitRequestData.OffsetCommitRequestTopic topic = requestTopicDataMap.getOrDefault(topicPartition.topic(), new OffsetCommitRequestData.OffsetCommitRequestTopic().setName(topicPartition.topic()));
            topic.partitions().add(new OffsetCommitRequestData.OffsetCommitRequestPartition().setPartitionIndex(topicPartition.partition()).setCommittedOffset(offsetAndMetadata.offset()).setCommittedLeaderEpoch(offsetAndMetadata.leaderEpoch().orElse(-1)).setCommittedMetadata(offsetAndMetadata.metadata()));
            requestTopicDataMap.put(topicPartition.topic(), topic);
        }
        if (this.subscriptions.partitionsAutoAssigned()) {
            generation = this.generation();
            if (generation == null) {
                this.log.info("Failing OffsetCommit request since the consumer is not part of an active group");
                return RequestFuture.failure(new CommitFailedException());
            }
        } else {
            generation = AbstractCoordinator.Generation.NO_GENERATION;
        }
        OffsetCommitRequest.Builder builder = new OffsetCommitRequest.Builder(new OffsetCommitRequestData().setGroupId(this.groupId).setGenerationId(generation.generationId).setMemberId(generation.memberId).setGroupInstanceId(this.groupInstanceId.orElse(null)).setTopics(new ArrayList<OffsetCommitRequestData.OffsetCommitRequestTopic>(requestTopicDataMap.values())));
        this.log.trace("Sending OffsetCommit request with {} to coordinator {}", offsets, (Object)coordinator);
        return this.client.send(coordinator, builder).compose(new OffsetCommitResponseHandler(offsets));
    }

    private RequestFuture<Map<TopicPartition, OffsetAndMetadata>> sendOffsetFetchRequest(Set<TopicPartition> partitions) {
        Node coordinator = this.checkAndGetCoordinator();
        if (coordinator == null) {
            return RequestFuture.coordinatorNotAvailable();
        }
        this.log.debug("Fetching committed offsets for partitions: {}", partitions);
        OffsetFetchRequest.Builder requestBuilder = new OffsetFetchRequest.Builder(this.groupId, new ArrayList<TopicPartition>(partitions));
        return this.client.send(coordinator, requestBuilder).compose(new OffsetFetchResponseHandler());
    }

    private static class OffsetCommitCompletion {
        private final OffsetCommitCallback callback;
        private final Map<TopicPartition, OffsetAndMetadata> offsets;
        private final Exception exception;

        private OffsetCommitCompletion(OffsetCommitCallback callback, Map<TopicPartition, OffsetAndMetadata> offsets, Exception exception) {
            this.callback = callback;
            this.offsets = offsets;
            this.exception = exception;
        }

        public void invoke() {
            if (this.callback != null) {
                this.callback.onComplete(this.offsets, this.exception);
            }
        }
    }

    private static class MetadataSnapshot {
        private final int version;
        private final Map<String, Integer> partitionsPerTopic;

        private MetadataSnapshot(SubscriptionState subscription, Cluster cluster, int version) {
            HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
            for (String topic : subscription.groupSubscription()) {
                partitionsPerTopic.put(topic, cluster.partitionCountForTopic(topic));
            }
            this.partitionsPerTopic = partitionsPerTopic;
            this.version = version;
        }

        boolean matches(MetadataSnapshot other) {
            return this.version == other.version || this.partitionsPerTopic.equals(other.partitionsPerTopic);
        }
    }

    private class ConsumerCoordinatorMetrics {
        private final String metricGrpName;
        private final Sensor commitLatency;

        private ConsumerCoordinatorMetrics(Metrics metrics, String metricGrpPrefix) {
            this.metricGrpName = metricGrpPrefix + "-coordinator-metrics";
            this.commitLatency = metrics.sensor("commit-latency");
            this.commitLatency.add(metrics.metricName("commit-latency-avg", this.metricGrpName, "The average time taken for a commit request"), new Avg());
            this.commitLatency.add(metrics.metricName("commit-latency-max", this.metricGrpName, "The max time taken for a commit request"), new Max());
            this.commitLatency.add(ConsumerCoordinator.this.createMeter(metrics, this.metricGrpName, "commit", "commit calls"));
            Measurable numParts = new Measurable(){

                @Override
                public double measure(MetricConfig config, long now) {
                    return ConsumerCoordinator.this.subscriptions.numAssignedPartitions();
                }
            };
            metrics.addMetric(metrics.metricName("assigned-partitions", this.metricGrpName, "The number of partitions currently assigned to this consumer"), numParts);
        }
    }

    private class OffsetFetchResponseHandler
    extends AbstractCoordinator.CoordinatorResponseHandler<OffsetFetchResponse, Map<TopicPartition, OffsetAndMetadata>> {
        private OffsetFetchResponseHandler() {
            super(ConsumerCoordinator.this);
        }

        @Override
        public void handle(OffsetFetchResponse response, RequestFuture<Map<TopicPartition, OffsetAndMetadata>> future) {
            if (response.hasError()) {
                Errors error = response.error();
                ConsumerCoordinator.this.log.debug("Offset fetch failed: {}", (Object)error.message());
                if (error == Errors.COORDINATOR_LOAD_IN_PROGRESS) {
                    future.raise(error);
                } else if (error == Errors.NOT_COORDINATOR) {
                    ConsumerCoordinator.this.markCoordinatorUnknown();
                    future.raise(error);
                } else if (error == Errors.GROUP_AUTHORIZATION_FAILED) {
                    future.raise(new GroupAuthorizationException(ConsumerCoordinator.this.groupId));
                } else {
                    future.raise(new KafkaException("Unexpected error in fetch offset response: " + error.message()));
                }
                return;
            }
            HashMap<TopicPartition, OffsetAndMetadata> offsets = new HashMap<TopicPartition, OffsetAndMetadata>(response.responseData().size());
            for (Map.Entry<TopicPartition, OffsetFetchResponse.PartitionData> entry : response.responseData().entrySet()) {
                TopicPartition tp = entry.getKey();
                OffsetFetchResponse.PartitionData data = entry.getValue();
                if (data.hasError()) {
                    Errors error = data.error;
                    ConsumerCoordinator.this.log.debug("Failed to fetch offset for partition {}: {}", (Object)tp, (Object)error.message());
                    if (error == Errors.UNKNOWN_TOPIC_OR_PARTITION) {
                        future.raise(new KafkaException("Topic or Partition " + tp + " does not exist"));
                    } else {
                        future.raise(new KafkaException("Unexpected error in fetch offset response for partition " + tp + ": " + error.message()));
                    }
                    return;
                }
                if (data.offset >= 0L) {
                    offsets.put(tp, new OffsetAndMetadata(data.offset, data.leaderEpoch, data.metadata));
                    continue;
                }
                ConsumerCoordinator.this.log.info("Found no committed offset for partition {}", (Object)tp);
            }
            future.complete(offsets);
        }
    }

    private class OffsetCommitResponseHandler
    extends AbstractCoordinator.CoordinatorResponseHandler<OffsetCommitResponse, Void> {
        private final Map<TopicPartition, OffsetAndMetadata> offsets;

        private OffsetCommitResponseHandler(Map<TopicPartition, OffsetAndMetadata> offsets) {
            super(ConsumerCoordinator.this);
            this.offsets = offsets;
        }

        @Override
        public void handle(OffsetCommitResponse commitResponse, RequestFuture<Void> future) {
            ConsumerCoordinator.this.sensors.commitLatency.record(this.response.requestLatencyMs());
            HashSet<String> unauthorizedTopics = new HashSet<String>();
            for (OffsetCommitResponseData.OffsetCommitResponseTopic topic : commitResponse.data().topics()) {
                for (OffsetCommitResponseData.OffsetCommitResponsePartition partition : topic.partitions()) {
                    TopicPartition tp = new TopicPartition(topic.name(), partition.partitionIndex());
                    OffsetAndMetadata offsetAndMetadata = this.offsets.get(tp);
                    long offset = offsetAndMetadata.offset();
                    Errors error = Errors.forCode(partition.errorCode());
                    if (error == Errors.NONE) {
                        ConsumerCoordinator.this.log.debug("Committed offset {} for partition {}", (Object)offset, (Object)tp);
                        continue;
                    }
                    if (error.exception() instanceof RetriableException) {
                        ConsumerCoordinator.this.log.warn("Offset commit failed on partition {} at offset {}: {}", new Object[]{tp, offset, error.message()});
                    } else {
                        ConsumerCoordinator.this.log.error("Offset commit failed on partition {} at offset {}: {}", new Object[]{tp, offset, error.message()});
                    }
                    if (error == Errors.GROUP_AUTHORIZATION_FAILED) {
                        future.raise(new GroupAuthorizationException(ConsumerCoordinator.this.groupId));
                        return;
                    }
                    if (error == Errors.TOPIC_AUTHORIZATION_FAILED) {
                        unauthorizedTopics.add(tp.topic());
                        continue;
                    }
                    if (error == Errors.OFFSET_METADATA_TOO_LARGE || error == Errors.INVALID_COMMIT_OFFSET_SIZE) {
                        future.raise(error);
                        return;
                    }
                    if (error == Errors.COORDINATOR_LOAD_IN_PROGRESS || error == Errors.UNKNOWN_TOPIC_OR_PARTITION) {
                        future.raise(error);
                        return;
                    }
                    if (error == Errors.COORDINATOR_NOT_AVAILABLE || error == Errors.NOT_COORDINATOR || error == Errors.REQUEST_TIMED_OUT) {
                        ConsumerCoordinator.this.markCoordinatorUnknown();
                        future.raise(error);
                        return;
                    }
                    if (error == Errors.FENCED_INSTANCE_ID) {
                        ConsumerCoordinator.this.log.error("Received fatal exception: group.instance.id gets fenced");
                        future.raise(error);
                        return;
                    }
                    if (error == Errors.UNKNOWN_MEMBER_ID || error == Errors.ILLEGAL_GENERATION || error == Errors.REBALANCE_IN_PROGRESS) {
                        ConsumerCoordinator.this.resetGeneration();
                        future.raise(new CommitFailedException());
                        return;
                    }
                    future.raise(new KafkaException("Unexpected error in commit: " + error.message()));
                    return;
                }
            }
            if (!unauthorizedTopics.isEmpty()) {
                ConsumerCoordinator.this.log.error("Not authorized to commit to topics {}", unauthorizedTopics);
                future.raise(new TopicAuthorizationException(unauthorizedTopics));
            } else {
                future.complete(null);
            }
        }
    }

    private class DefaultOffsetCommitCallback
    implements OffsetCommitCallback {
        private DefaultOffsetCommitCallback() {
        }

        @Override
        public void onComplete(Map<TopicPartition, OffsetAndMetadata> offsets, Exception exception) {
            if (exception != null) {
                ConsumerCoordinator.this.log.error("Offset commit with offsets {} failed", offsets, (Object)exception);
            }
        }
    }

    private static class PendingCommittedOffsetRequest {
        private final Set<TopicPartition> requestedPartitions;
        private final AbstractCoordinator.Generation requestedGeneration;
        private final RequestFuture<Map<TopicPartition, OffsetAndMetadata>> response;

        private PendingCommittedOffsetRequest(Set<TopicPartition> requestedPartitions, AbstractCoordinator.Generation generationAtRequestTime, RequestFuture<Map<TopicPartition, OffsetAndMetadata>> response) {
            this.requestedPartitions = Objects.requireNonNull(requestedPartitions);
            this.response = Objects.requireNonNull(response);
            this.requestedGeneration = generationAtRequestTime;
        }

        private boolean sameRequest(Set<TopicPartition> currentRequest, AbstractCoordinator.Generation currentGeneration) {
            return Objects.equals(this.requestedGeneration, currentGeneration) && this.requestedPartitions.equals(currentRequest);
        }
    }
}

