#!/usr/bin/python
#
#  Copyright 2002-2022 Barcelona Supercomputing Center (www.bsc.es)
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.
#

# -*- coding: utf-8 -*-

import os


def test_launch_application():
    from pycompss.runtime.launch import launch_pycompss_application

    current_path = os.path.dirname(os.path.abspath(__file__))
    app = os.path.join(current_path, "resources", "increment.py")
    launch_pycompss_application(
        app, "main", debug=True, app_name="increment", trace=True
    )


def test_launch_application_with_mpi_worker():
    from pycompss.runtime.launch import launch_pycompss_application

    current_path = os.path.dirname(os.path.abspath(__file__))
    app = os.path.join(current_path, "resources", "increment.py")
    launch_pycompss_application(
        app, "main", debug=True, app_name="increment", trace=True, mpi_worker=True
    )
